% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unroll.function.R
\name{unroll.function}
\alias{unroll.function}
\title{Convert a function with matrix arguments to a function with vector
arguments.}
\usage{
unroll.function(mat.fn, ...)
}
\arguments{
\item{mat.fn}{A function with any number of arguments, some of which are
matrices.}

\item{\dots}{A series of other arguments.  Their names define which
arguments of \code{mat.fn} are matrices.  Their values define a vector of
strings to be appended to the names of the arguments in the new function.
For example

\code{fn <- unroll.function(oldfn, gamma=1:3, alpha=0:1)}

will make a new function \code{fn} with arguments
\code{gamma1},\code{gamma2},\code{gamma3},\code{alpha0},\code{alpha1}.

Calling

\code{fn(gamma1=a,gamma2=b,gamma3=c,alpha0=d,alpha1=e)}

should give the same answer as

\code{oldfn(gamma=cbind(a,b,c),alpha=cbind(d,e))}}
}
\value{
The new function, with vector arguments.
}
\description{
Given a function with matrix arguments, construct an equivalent function
which takes vector arguments defined by the columns of the matrix.  The new
function simply uses \code{cbind} on the vector arguments to make a matrix,
and calls the old one.
}
\section{Usage in \pkg{flexsurv}}{


This is used by \code{\link{flexsurvspline}} to allow spline models, which
have an arbitrary number of parameters, to be fitted using
\code{\link{flexsurvreg}}.

The ``custom distributions'' facility of \code{\link{flexsurvreg}}
expects the user-supplied probability density and distribution
functions to have one explicitly named argument for each scalar
parameter, and given R vectorisation, each of those arguments
could be supplied as a vector of alternative parameter values.

However, spline models have a varying number of scalar parameters,
determined by the number of knots in the spline.
\code{\link{dsurvspline}} and \code{\link{psurvspline}} have an
argument called \code{gamma}.  This can be supplied as a matrix,
with number of columns \code{n} determined by the number of knots
(plus 2), and rows referring to alternative parameter values.  The
following statements are used in the source of
\code{flexsurvspline}: \preformatted{ dfn <-
unroll.function(dsurvspline, gamma=0:(nk-1)) pfn <-
unroll.function(psurvspline, gamma=0:(nk-1)) }

to convert these into functions with arguments \code{gamma0},
\code{gamma1},\ldots{},\code{gamman}, corresponding to the columns
of \code{gamma}, where \code{n = nk-1}, and with other arguments
in the same format.
}

\examples{

fn <- unroll.function(ncol, x=1:3)
fn(1:3, 1:3, 1:3) # equivalent to...
ncol(cbind(1:3,1:3,1:3))
}
\seealso{
\code{\link{flexsurvspline}},\code{\link{flexsurvreg}}
}
\author{
Christopher Jackson <chris.jackson@mrc-bsu.cam.ac.uk>
}
