% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{hrule}
\alias{hrule}
\title{Set flextable rule for rows heights}
\usage{
hrule(x, i = NULL, rule = "auto", part = "body")
}
\arguments{
\item{x}{flextable object}

\item{i}{rows selection}

\item{rule}{specify the meaning of the height. Possible values
are "atleast" (height should be at least the value specified), "exact"
(height should be exactly the value specified), or the default value "auto"
(height is determined based on the height of the contents, so the value is ignored).
See details for more informations.}

\item{part}{partname of the table, one of "all", "header", "body", "footer"}
}
\description{
control rules of each height for a part
of the flextable, this is only for Word and HTML outputs, it
will not have any effect when output is PowerPoint.
}
\examples{

ft <- flextable(iris)
ft <- width(iris, width = 1.5)
ft <- height(ft, height = 0.75, part = "header")
ft <- hrule(ft, rule = "exact", part = "header")

}
\seealso{
Other flextable dimensions: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{height}()},
\code{\link{width}()}
}
\concept{flextable dimensions}
