% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatters.R
\name{colformat_num}
\alias{colformat_num}
\title{format numeric cells}
\usage{
colformat_num(
  x,
  i = NULL,
  j = NULL,
  big.mark = get_flextable_defaults()$big.mark,
  decimal.mark = get_flextable_defaults()$decimal.mark,
  digits = get_flextable_defaults()$digits,
  na_str = get_flextable_defaults()$na_str,
  prefix = "",
  suffix = ""
)
}
\arguments{
\item{x}{a flextable object}

\item{i}{rows selection}

\item{j}{columns selection.}

\item{big.mark, digits, decimal.mark}{see \code{\link[=format]{format()}}}

\item{na_str}{string to be used for NA values}

\item{prefix}{string to be used as prefix or suffix}

\item{suffix}{string to be used as prefix or suffix}
}
\description{
Format numeric cells in a flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_colformat_num_1.png}{options: width=50\%}}
}

\examples{
dat <- mtcars
ft <- flextable(head(dat))
ft <- colformat_num(x = ft,
  big.mark=",", digits = 2, na_str = "N/A")
ft <- autofit(ft)
ft
}
\seealso{
Other cells formatters: 
\code{\link{colformat_char}()},
\code{\link{colformat_datetime}()},
\code{\link{colformat_date}()},
\code{\link{colformat_double}()},
\code{\link{colformat_image}()},
\code{\link{colformat_int}()},
\code{\link{colformat_lgl}()},
\code{\link{compose}()},
\code{\link{set_formatter}()}
}
\concept{cells formatters}
