% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizor.R
\name{as_flextable.summarizor}
\alias{as_flextable.summarizor}
\title{Transform a 'summarizor' object into a flextable}
\usage{
\method{as_flextable}{summarizor}(x, ...)
}
\arguments{
\item{x}{result from \code{\link[=summarizor]{summarizor()}}}

\item{...}{arguments for \code{\link[=as_flextable.tabulator]{as_flextable.tabulator()}}}
}
\description{
\code{summarizor} object should be transformed into a flextable
with method \code{\link[=as_flextable]{as_flextable()}}.
}
\examples{
z <- summarizor(CO2[-c(1, 4)],
  by = "Treatment",
  overall_label = "Overall"
)
ft_1 <- as_flextable(z, spread_first_col = TRUE)
ft_1 <- prepend_chunks(ft_1,
  i = ~ is.na(variable), j = 1,
  as_chunk("\t"))
ft_1 <- autofit(ft_1)
ft_1
}
\seealso{
Other as_flextable methods: 
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()},
\code{\link{as_flextable}()}
}
\concept{as_flextable methods}
