% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{naiveBlockPermute1}
\alias{naiveBlockPermute1}
\title{Resampling V Statistic (Version 1)}
\usage{
naiveBlockPermute1(X, block_labels, p = 2)
}
\arguments{
\item{X}{The \eqn{N \times P} binary or real matrix}

\item{block_labels}{A vector of length \eqn{P}, whose \eqn{p}th component indicates the block membership of feature \eqn{p}}

\item{p}{The power \eqn{p} of \eqn{l_p^p}, i.e., \eqn{||x||_p^p = (x_1^p+...x_n^p)}}
}
\value{
\eqn{V(\mathbf{X}')}, where \eqn{\mathbf{X}'} is a resampled by permutation of entries blockwise
}
\description{
Generates a new array \eqn{\mathbf{X}'} under the permutation null and then
returns the \eqn{V} statistic computed for \eqn{\mathbf{X}'}.
}
\details{
This is Version 1, which takes in the block labels. It is suitable in
the most general setting, where the features are grouped by labels.
Given original \eqn{\mathbf{X}} and a list denoting labels of each feature,
independently permutes the rows within each block of \eqn{\mathbf{X}} and returns resulting \eqn{V}.
If block labels are not specified, then features are assumed independent, which
is to say that block_labels is set to 1:ncol(\eqn{\mathbf{X}}).

Dependencies: getBinVStat, getRealVStat
}
\examples{
X <- matrix(nrow = 5, ncol = 10, rnorm(50)) # real matrix example
naiveBlockPermute1(X, block_labels = c(1,1,2,2,3,3,4,4,5,5), p = 2) # use Euclidean distance

X <- matrix(nrow = 5, ncol = 10, rbinom(50, 1, 0.5)) # binary matrix example
naiveBlockPermute1(X, block_labels = c(1,1,2,2,3,3,4,4,5,5))

}
