% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/to-flow.R
\name{to_flow}
\alias{to_flow}
\alias{to_flow.data.frame}
\alias{to_flow.list}
\alias{to_flow.vector}
\title{Create flow objects}
\usage{
to_flow(x, ...)

\method{to_flow}{vector}(x, def, grp_col, jobname_col, cmd_col, ...)

\method{to_flow}{data.frame}(x, def, grp_col, jobname_col, cmd_col, flowname,
  flow_run_path, platform, submit = FALSE, execute = FALSE, qobj, ...)

\method{to_flow}{list}(x, def, flowname, flow_run_path, desc, qobj, ...)
}
\arguments{
\item{x}{path (char. vector) to flow_mat, a data.frame or a list.}

\item{...}{Supplied to specific functions like \link{to_flow.data.frame}}

\item{def}{A flow definition table. Basically a table with resource requirements and mapping of the jobs in this flow}

\item{grp_col}{column name used to split x (flow_mat). Default: `samplename`}

\item{jobname_col}{column name with job names. Default: `jobname`}

\item{cmd_col}{column name with commands. Default: `cmd`}

\item{flowname}{name of the flow}

\item{flow_run_path}{Path to a folder. Main operating folder for this flow. Default it `get_opts("flow_run_path")`.}

\item{platform}{character vector, specifying the platform to use. local, lsf, torque, moab, sge, slurm, ...
This over-rides the platform column in flowdef.}

\item{submit}{Depreciated. Use submit_flow on flow object this function returns. TRUE/FALSE}

\item{execute}{Depreciated. Use submit_flow on flow object this function returns. TRUE/FALSE, an paramter to submit_flow()}

\item{qobj}{Depreciated, modify \href{http://docs.flowr.space/en/latest/rd/vignettes/build-pipes.html#cluster-interface}{cluster templates} instead.  A object of class \link{queue}.}

\item{desc}{Advanced Use. final flow name, please don't change.}
}
\value{
Returns a flow object. If execute=TRUE, fobj is rich with information about where and how
the flow was executed. It would include details like jobids, path to exact scripts run etc.
To use kill_flow, to kill all the jobs one would need a rich flow object, with job ids present.

\subsection{Behaviour:}{
What goes in, and what to expect in return?
\itemize{
\item submit=FALSE & execute=FALSE: Create and return a flow object
\item submit=TRUE & execute=FALSE: dry-run, Create a flow object then, create a structured execution folder with all the commands
\item submit=TRUE, execute=TRUE: Do all of the above and then, submit to cluster
}
}
}
\description{
Use a set of shell commands and flow definiton to create \link{flow} object.
}
\details{
The parameter x can be a path to a flow_mat, or a data.frame (as read by read_sheet).
This is a minimum three column matrix with three columns: samplename, jobname and cmd
}
\examples{
ex = file.path(system.file(package = "flowr"), "pipelines")
flowmat = as.flowmat(file.path(ex, "sleep_pipe.tsv"))
flowdef = as.flowdef(file.path(ex, "sleep_pipe.def"))
fobj = to_flow(x = flowmat, def = flowdef, flowname = "sleep_pipe", platform = "lsf")
}

