% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/flows.R
\name{plotDomFlows}
\alias{plotDomFlows}
\title{Dominant Flows Graph}
\usage{
plotDomFlows(mat, legend.flows.pos = "topright",
  legend.flows.title = "Flows Intensity", legend.nodes.pos = "bottomright",
  legend.node.txt = c("Dominant", "Intermediary", "Dominated",
  "Size proportional\\nto sum of inflows"), labels = FALSE)
}
\arguments{
\item{mat}{A square matrix of dominant flows (see \link{domflows}).}

\item{legend.flows.pos}{Position of the flows legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright".}

\item{legend.flows.title}{Title of the flows legend.}

\item{legend.nodes.pos}{Position of the nodes legend, one of "topleft", "top",
"topright", "left", "right", "bottomleft", "bottom", "bottomright".}

\item{legend.node.txt}{Text of the nodes legend.}

\item{labels}{A boolean, if TRUE, labels of dominant and intermediary nodes are plotted.}
}
\description{
This function plots a dominant flows graph.
}
\note{
As square matrices can easily be plot with \link[igraph]{plot.igraph} or
\link[sna]{gplot} functions from igraph and sna packages, we do not propose
visualisation for other outputs.
}
\examples{
# Import data
data(nav)
myflows <- prepflows(mat = nav, i = "i", j = "j", fij = "fij")

# Remove the matrix diagonal
diag(myflows) <- 0

# Select the dominant flows (incoming flows criterion)
flowSel1 <- domflows(mat = myflows, wi = colSums(myflows), wj = rowSums(myflows),
                     k = 1)
# Select the first flows
flowSel2 <- firstflows(mat = myflows, method = "nfirst", ties.method = "first",
                       k = 1)

# Combine selections
flowSel <- myflows * flowSel1 * flowSel2

# Plot dominant flows graph
plotDomFlows(mat = flowSel, legend.flows.title = "Nb. of commuters")
}
\seealso{
\link{domflows}, \link{plotMapDomFlows}
}

