% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux_fitting.R
\name{flux_fitting}
\alias{flux_fitting}
\title{Fitting a model to concentration data and estimating the slope}
\usage{
flux_fitting(
  conc_df,
  conc_col,
  datetime_col,
  f_start = f_start,
  f_end = f_end,
  f_fluxid = f_fluxid,
  start_cut = 0,
  end_cut = 0,
  t_window = 20,
  cz_window = 15,
  b_window = 10,
  a_window = 10,
  roll_width = 15,
  t_zero = 0,
  fit_type
)
}
\arguments{
\item{conc_df}{dataframe of gas concentration over time}

\item{conc_col}{column with gas concentration data}

\item{datetime_col}{column with datetime of each concentration measurement
Note that if there are duplicated datetime in the same f_fluxid only
the first row will be kept}

\item{f_start}{column with datetime when the measurement started}

\item{f_end}{column with datetime when the measurement ended}

\item{f_fluxid}{column with ID of each flux}

\item{start_cut}{time to discard at the start of the measurements
(in seconds)}

\item{end_cut}{time to discard at the end of the measurements (in seconds)}

\item{t_window}{enlarge focus window before and after tmin and tmax
(exponential fit)}

\item{cz_window}{window used to calculate Cz, at the beginning of cut window
(exponential fit)}

\item{b_window}{window to estimate b. It is an interval after tz where
it is assumed that the model fits the data perfectly (exponential fit)}

\item{a_window}{window at the end of the flux to estimate a (exponential fit)}

\item{roll_width}{width of the rolling mean for CO2 when looking for tz,
ideally same as cz_window (exponential fit)}

\item{t_zero}{time at which the slope should be calculated
(for quadratic fit)}

\item{fit_type}{\code{exponential}, \code{quadratic} or \code{linear.}
Exponential is using the exponential model from Zhao et al (2018)}
}
\value{
a dataframe with the slope at t zero (\code{f_slope}),
a datetime column of t zero (\code{f_start_z}), a factor column indicating the
cuts (\code{f_cut}), the time in seconds since the start of the measurement
(\code{f_time}), the modeled fit (\code{f_fit}), the modeled slope (\code{f_fit_slope}),
the parameters of the fit depending on the model used,
and any columns present in the input.
The type of fit is added as an attribute for use by the other functions.
}
\description{
fits gas concentration over time data with a model
(exponential, quadratic or linear) and provides the slope later used
to calculate gas fluxes with flux_calc
}
\examples{
data(co2_conc)
flux_fitting(co2_conc, conc, datetime, fit_type = "exp")
flux_fitting(co2_conc, conc, datetime,  fit_type = "quadratic",
t_zero = 10, end_cut = 30)
}
\references{
Zhao, P., Hammerle, A., Zeeman, M., Wohlfahrt, G., 2018.
On the calculation of daytime CO2 fluxes measured by automated closed
transparent chambers. Agricultural and Forest Meteorology 263, 267–275.
https://doi.org/10.1016/j.agrformet.2018.08.022
}
