% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity}
\alias{sensitivity}
\title{sensitivity analysis}
\usage{
sensitivity(fun.name, param.name, var, n, full.output = FALSE, ...)
}
\arguments{
\item{fun.name}{Function to analyse.}

\item{param.name}{Parameter from \code{...} on which variation is applied.}

\item{var}{Define the interval of uncertainty for the uniform law around \code{x} as \code{[x - x*var, x + x*var]}.}

\item{n}{Number of replicates.}

\item{full.output}{Logical, if \code{TRUE} all of \code{n} estimations of \code{fun.name} are returned. Only their mean otherwise.}

\item{...}{Arguments to be passed to \code{fun.name}. Argument names must exactly match those of fun.name.}
}
\value{
a list of two elements of the same type as \code{param.name}: 
first element contains the mean coefficient of variation in comparison to non randomised inputs among all the replicates, 
second element contains the standard deviation of these coefficient of variation
}
\description{
Assesses how sensitive the results from argument function are to variability of input parameter through coefficient of variation.
}
\details{
At each replicate, a coefficient of variation is computed (relative to results obtained form \code{fun.name} without random variation).
if \code{full.output} is \code{FALSE} (default) a list of two objects of the same type as the one produced by \code{fun.name} is returned, 
first element contains the mean coefficient of variation in comparison to non randomised inputs among all the replicates, 
second element contains the standard deviation of these coefficients of variation
If \code{full.output} is \code{TRUE}, a list of size \code{n} with of objects containing the coefficients of variation  is returned.

Argument for \code{...} should be passed with their names.
}
\examples{

# first compute species per unit biomass metabolic rates using the metabolic theory:
losses = 0.1 * species.level$bodymasses^(-0.25)


res = sensitivity(fluxing, "mat", 0.1, 5, full.output = TRUE, 
                 mat = species.level$mat, 
                 biomasses = species.level$biomasses, 
                 losses = losses, 
                 efficiencies = species.level$efficiencies)
res = sensitivity(fluxing, "efficiencies", 0.01, 50, 
                 mat = species.level$mat, 
                 biomasses = species.level$biomasses, 
                 losses = losses, 
                 efficiencies = species.level$efficiencies)

# growth rates of basal species
growth.rates = rep(NA, dim(species.level$mat)[1])
growth.rates[colSums(species.level$mat) == 0] = 0.5

val.mat = fluxing(species.level$mat, species.level$biomasses, losses, species.level$efficiencies)



}
