% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_shp.R
\name{import_shp}
\alias{import_shp}
\title{Read shapefiles}
\usage{
import_shp(pathshp, FUN = rgdal::readOGR, dsnlayerbind = F,
  data_source = flyio_get_datasource(),
  bucket = flyio_get_bucket(data_source), dir = flyio_get_dir(),
  delete_file = TRUE, show_progress = FALSE, ...)
}
\arguments{
\item{pathshp}{path of the shp file to be read}

\item{FUN}{the function using which the file is to be read}

\item{dsnlayerbind}{if the FUN needs dsn and layer binded or not}

\item{data_source}{the name of the data source, if not set globally. s3, gcs or local}

\item{bucket}{the name of the bucket, if not set globally}

\item{dir}{the directory to store intermediate files}

\item{delete_file}{logical. to delete the file downloaded}

\item{show_progress}{logical. Shows progress of the download operation}

\item{...}{other parameters for the FUN function defined above}
}
\value{
the output of the FUN function
}
\description{
Read shapefiles data from anywhere using a function defined by you
}
\examples{
\dontrun{
# import shapefile from Google Cloud
flyio_set_datasource("gcs")
flyio_set_bucket("your-bucket-name")
t = import_shp("shptest-on-cloud.shp", FUN = readOGR, dsnlayerbind = F, dir = tempdir())
t = import_shp("shptest-on-cloud.shp", FUN = raster::shapefile, dsnlayerbind = T, dir = tempdir())
}
}
