% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autostop.R
\name{convergence-checker}
\alias{convergence-checker}
\alias{automatic-stop}
\alias{convergence_gelman}
\alias{convergence_geweke}
\alias{convergence_heildel}
\alias{convergence_auto}
\title{Convergence Monitoring}
\usage{
convergence_gelman(freq = 1000L, threshold = 1.1,
  check_invariant = TRUE, ...)

convergence_geweke(freq = 1000L, threshold = 0.025,
  check_invariant = TRUE, ...)

convergence_heildel(freq = 1000L, ..., check_invariant = TRUE)

convergence_auto(freq = 1000L)
}
\arguments{
\item{freq}{Integer scalar. Frequency of checking.}

\item{threshold}{Numeric value. A Gelman statistic below the threshold
will return \code{TRUE}.}

\item{check_invariant}{Logical. When \code{TRUE} the function only computes
the Gelman diagnostic using variables with greater than \code{1e-10} variance.}

\item{...}{Further arguments passed to the method.}
}
\value{
A function passed to \link{MCMC} to check automatic convergence.
}
\description{
Built-in set of functions to be used in companion with the argument
\code{conv_checker} in \link{MCMC}. These functions are not intended to be used
in a context other than the \code{MCMC} function.
}
\details{
In the case of \code{convergence_geweke}, \code{threshold} sets the p-value
for the null \eqn{H_0: Z = 0}, i.e. equal means between the first and last
chunks of the chain. See \link[coda:geweke.diag]{coda::geweke.diag}. This implies that the higher
the threshold, the lower the probability of stopping the chain.

In the case that the chain has more than one parameter, the algorithm will
return true if and only if the test fails to reject the null for all the
parameters.

For the \code{convergence_heildel}, see \link[coda:heidel.diag]{coda::heidel.diag} for details.

The \code{convergence_auto} function is the default and is just a wrapper
for \code{convergence_gelman} and \code{convergence_geweke}. This function returns a
convergence checker that will be either of the other two depending on whether
\code{nchains} in \code{MCMC} is greater than one--in which case it will use the Gelman
test--or not--in which case it will use the Geweke test.
}
