% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_adapt.R
\name{kernel_adapt}
\alias{kernel_adapt}
\alias{kernel_am}
\title{Adaptive Metropolis (AM) Transition Kernel}
\usage{
kernel_adapt(
  mu = 0,
  bw = 0L,
  lb = -.Machine$double.xmax,
  ub = .Machine$double.xmax,
  freq = 1L,
  warmup = 500L,
  Sigma = NULL,
  Sd = NULL,
  eps = 1e-04,
  fixed = FALSE,
  until = Inf
)

kernel_am(
  mu = 0,
  bw = 0L,
  lb = -.Machine$double.xmax,
  ub = .Machine$double.xmax,
  freq = 1L,
  warmup = 500L,
  Sigma = NULL,
  Sd = NULL,
  eps = 1e-04,
  fixed = FALSE,
  until = Inf
)
}
\arguments{
\item{mu}{Either a numeric vector or a scalar. Proposal mean.
If scalar, values are recycled to match the number of parameters in the
objective function.}

\item{bw}{Integer scalar. The bandwidth, is the number of observations to
include in the computation of the variance-covariance matrix.}

\item{lb, ub}{Either a numeric vector or a scalar. Lower and upper bounds for
bounded kernels. When of length 1, the values are recycled to match the number
of parameters in the objective function.}

\item{freq}{Integer scalar. Frequency of updates. How often the
variance-covariance matrix is updated. The implementation is different from that
described in the original paper (see details).}

\item{warmup}{Integer scalar. The number of iterations that the algorithm has
to wait before starting to do the updates.}

\item{Sigma}{The variance-covariance matrix. By default this will be an
identity matrix during the warmup period.}

\item{Sd}{Overall scale for the algorithm. By default, the variance-covariance
is scaled to \eqn{2.4^2/d}, with \eqn{d} the number of dimensions.}

\item{eps}{Double scalar. Default size of the initial step (see details).}

\item{fixed}{Logical scalar or vector of length \code{k}. Indicates which parameters
will be treated as fixed or not. Single values are recycled.}

\item{until}{Integer scalar. Last step at which adaptation takes place (see
details).}
}
\value{
An object of class \link{fmcmc_kernel}. \code{fmcmc_kernel} objects are intended
to be used with the \code{\link[=MCMC]{MCMC()}} function.
}
\description{
Implementation of Haario et al. (2001)'s Adaptive Metropolis.
}
\details{
While it has been shown that under regular conditions this transition kernel
generates ergodic chains even when the adaptation does not stop, some
practitioners may want to stop adaptation at some point.

\code{kernel_adapt} Implements the adaptive Metropolis (AM) algorithm of Haario
et al. (2001). If the value of bw is greater than zero, then the algorithm
folds back AP, a  previous version which is known to have ergodicity problems.

The parameter \code{eps} has two functions. The first one is to set the initial
scale for the multivariate normal kernel, which is replaced after \code{warmup}
steps with the actual variance-covariance computed by the main algorithm.
The second usage is in the equation that ensures that the variance-covariance
is greater than zero, this is, the \eqn{\varepsilon}{epsilon} parameter in the
original paper.

The update of the covariance matrix is done using \code{\link[=cov_recursive]{cov_recursive()}} function,
which makes the updates faster. The \code{freq} parameter, besides of indicating the
frequency with which the updates are done, it specifies what are the samples
included in each update, in other words, like a thinning parameter, only every
\code{freq} samples will be used to compute the covariance matrix. Since this
implementation uses the recursive formula for updating the covariance, there is
no practical need to set \code{freq != 1}.

\code{kernel_am} is just an alias for \code{kernel_adapt}.
}
\examples{
# Update every-step and wait 1,000 steps before starting to adapt
kern <- kernel_adapt(freq = 1, warmup = 1000)

# Two parameters model, the second parameter with a restricted range, i.e.
# a lower bound of 1
kern <- kernel_adapt(lb = c(-.Machine$double.xmax, 0))
}
\references{
Haario, H., Saksman, E., & Tamminen, J. (2001). An adaptive Metropolis algorithm.
Bernoulli, 7(2), 223–242.
\url{https://projecteuclid.org/euclid.bj/1080222083}
}
\seealso{
Other kernels: 
\code{\link{kernel_mirror}},
\code{\link{kernel_new}()},
\code{\link{kernel_normal}()},
\code{\link{kernel_ram}()},
\code{\link{kernel_unif}()}
}
\concept{kernels}
