% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar-classes.R
\name{Calendar}
\alias{Calendar}
\alias{EmptyCalendar}
\alias{AUSYCalendar}
\alias{AUMECalendar}
\alias{CHZHCalendar}
\alias{EUTACalendar}
\alias{GBLOCalendar}
\alias{HKHKCalendar}
\alias{JPTOCalendar}
\alias{NOOSCalendar}
\alias{NZAUCalendar}
\alias{NZWECalendar}
\alias{USNYCalendar}
\title{Build a calendar}
\usage{
Calendar(locale, tz)

EmptyCalendar()

AUSYCalendar()

AUMECalendar()

CHZHCalendar()

EUTACalendar()

GBLOCalendar()

HKHKCalendar()

JPTOCalendar()

NOOSCalendar()

NZAUCalendar()

NZWECalendar()

USNYCalendar()
}
\arguments{
\item{locale}{a four letter string representing an abbreviation of the
locale. The package uses locale representations loosely based on
\href{http://www.unece.org/cefact/locode/welcome.html}{UN/LOCODE} (e.g.
Australia/Sydney is represented by \code{AUSY} rather than \code{AU/SYD} per the
LOCODE specification). The locale is used as a prefix to the calendar's
S3 class in the following manner: \code{<locale>Calendar} (e.g. \code{AUSYCalendar}).}

\item{tz}{the time zone associated with the given \code{locale} using
\code{\link[=OlsonNames]{OlsonNames()}} (e.g. \code{Australia/Sydney})}
}
\value{
\code{Calendar()} returns a function that constructs an object inheriting
from the \code{Calendar} class. The calendar constructors provided by the
package returns an object that inherits from \code{Calendar}.
}
\description{
Calendars are necessary for two reasons: they define whether a calendar day
is a good business day in a given locale and they are used to store the time
zone for the locale. Calendars can correspond to a single locale (usually a
city). These inherit from the \code{Calendar} class. The package implements a
number of calendars for key financial market locales such as
\code{AUSYCalendar}, \code{USNYCalendar} and \code{EUTACalendar} (TARGET). You can
also define a joint locale using \code{\link[=JointCalendar]{JointCalendar()}}.
}
\examples{
Calendar(NA, NA) # Defined: EmptyCalendar()
Calendar("AUSY", "Australia/Sydney") # Defined: AUSYCalendar()
}
\seealso{
Other calendar classes: \code{\link{JointCalendar}}
}
