% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-counters.R
\name{actual_360}
\alias{actual_360}
\title{The years between two dates using the actual/360 day basis convention.}
\usage{
actual_360(date1, date2)
}
\arguments{
\item{date1}{A date-time object}

\item{date2}{A date-time object}
}
\value{
a numeric value representing the number of years between
\code{date1} and \code{date2}.
}
\description{
This calculates the years between two dates using the actual/360 day basis
convention. This convention counts the number of calendars between the start
and end dates and assumes a year consists of 360 days. This is also known
as the A/360, Act/360 or French day basis convention.
}
\details{
The year fraction is calculated as:
\deqn{\frac{Number of calendar days}{360}}

The order of \code{date1} and \code{date2} is not important. If \code{date1}
is less than \code{date2} then the result will be non-negative. Otherwise,
the result will be negative.
}
\seealso{
Other counter methods: \code{\link{actual_365}},
  \code{\link{actual_actual_isda}},
  \code{\link{is_valid_day_basis}},
  \code{\link{thirty_360_eu_isda}},
  \code{\link{thirty_360_eu_plus}},
  \code{\link{thirty_360_eu}}, \code{\link{thirty_360_us}},
  \code{\link{thirty_360}}, \code{\link{year_frac}}
}
\keyword{internal}
