% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bary.R
\name{fm_bary_loc}
\alias{fm_bary_loc}
\alias{fm_bary_loc.fm_mesh_2d}
\alias{fm_bary_loc.fm_mesh_3d}
\alias{fm_bary_loc.fm_mesh_1d}
\alias{fm_bary_loc.fm_lattice_2d}
\alias{fm_bary_loc.fm_lattice_Nd}
\title{Extract Euclidean Sgeometry from Barycentric coordinates}
\usage{
fm_bary_loc(mesh, bary = NULL, ..., format = NULL)

\method{fm_bary_loc}{fm_mesh_2d}(mesh, bary = NULL, ..., format = NULL)

\method{fm_bary_loc}{fm_mesh_3d}(mesh, bary = NULL, ..., format = NULL)

\method{fm_bary_loc}{fm_mesh_1d}(mesh, bary = NULL, ..., format = NULL)

\method{fm_bary_loc}{fm_lattice_2d}(mesh, bary = NULL, ..., format = NULL)

\method{fm_bary_loc}{fm_lattice_Nd}(mesh, bary = NULL, ..., format = NULL)
}
\arguments{
\item{mesh}{A mesh object, e.g. \link{fm_mesh_2d} or \link{fm_mesh_1d}.}

\item{bary}{An \code{fm_bary} object. If \code{NULL}, return the mesh nodes is the mesh
class supports it, otherwise gives an error.}

\item{\dots}{Further arguments potentially used by sub-methods.}

\item{format}{Optional format for the output. If \code{NULL}, the output format
is determined by the default for the mesh object.}
}
\value{
Output format depends on the mesh \code{class}.
}
\description{
Extract the Euclidean coordinates for location identified by an \link{fm_bary}
object. This acts as the inverse of \code{fm_bary()}.
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_bary_loc(fm_mesh_2d)}: Extract points on a triangle mesh. Implemented
formats are \code{"matrix"} (default) and \code{"sf"}.

\item \code{fm_bary_loc(fm_mesh_3d)}: Extract points on a tetrahedron mesh. Implemented
format is \code{"matrix"} (default).

\item \code{fm_bary_loc(fm_mesh_1d)}: Extract points on a 1D mesh. Implemented
formats are \code{"numeric"} (default).

\item \code{fm_bary_loc(fm_lattice_2d)}: Extract points on a 2D lattice. Implemented
formats are \code{"matrix"} (default) and \code{"sf"}.

\item \code{fm_bary_loc(fm_lattice_Nd)}: Extract points on a ND lattice.

}}
\examples{
head(fm_bary_loc(fmexample$mesh))
bary <- fm_bary(fmexample$mesh, fmexample$loc_sf)
fm_bary_loc(fmexample$mesh, bary, format = "matrix")
fm_bary_loc(fmexample$mesh, bary, format = "sf")
(m <- fm_mesh_3d(
  matrix(c(1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0), 4, 3, byrow = TRUE),
  matrix(c(1, 2, 3, 4), 1, 4, byrow = TRUE)
))
(bary <- fm_bary(m, rbind(
  cbind(0.1, 0.2, 0.3),
  cbind(-0.1, 0.2, 0.3)
)))
fm_bary_loc(m, bary)
mesh1 <- fm_mesh_1d(1:4)
fm_bary_loc(mesh1)
(bary1 <- fm_bary(mesh1, seq(0, 5, by = 0.5)))
fm_bary_loc(mesh1, bary1)
(bary1 <- fm_bary(mesh1, seq(0, 5, by = 0.5), restricted = TRUE))
fm_bary_loc(mesh1, bary1)
fm_basis(mesh1, bary1)
(bary1 <- fm_bary(mesh1, bary1, method = "nearest"))
fm_bary_loc(mesh1, bary1)
fm_basis(mesh1, bary1)
(bary1 <- fm_bary(mesh1, bary1, method = "linear"))
fm_bary_loc(mesh1, bary1)
fm_basis(mesh1, bary1)
m <- fm_lattice_2d(x = 1:3, y = 1:4)
head(fm_bary_loc(m))
(bary <- fm_bary(m, cbind(1.5, 3.2)))
fm_bary_loc(m, bary, format = "matrix")
fm_bary_loc(m, bary, format = "sf")
m <- fm_lattice_Nd(list(x = 1:3, y = 1:4, z = 1:2))
head(fm_bary_loc(m))
(bary <- fm_bary(m, cbind(1.5, 3.2, 1.5)))
fm_bary_loc(m, bary)
}
\seealso{
\code{\link[=fm_bary]{fm_bary()}}, \code{\link[=fm_bary_simplex]{fm_bary_simplex()}}
}
