% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis.R
\name{fm_basis}
\alias{fm_basis}
\alias{fm_basis.default}
\alias{fm_basis.fm_mesh_1d}
\alias{fm_basis.fm_mesh_2d}
\alias{fm_basis.fm_mesh_3d}
\alias{fm_basis.fm_lattice_2d}
\alias{fm_basis.fm_lattice_Nd}
\alias{fm_basis.fm_tensor}
\alias{fm_basis.fm_collect}
\alias{fm_basis.matrix}
\alias{fm_basis.Matrix}
\alias{fm_basis.list}
\alias{fm_basis.fm_basis}
\alias{fm_basis.fm_evaluator}
\title{Compute mapping matrix between mesh function space and points}
\usage{
fm_basis(x, ..., full = FALSE)

\method{fm_basis}{default}(x, ..., full = FALSE)

\method{fm_basis}{fm_mesh_1d}(x, loc, weights = NULL, derivatives = NULL, ..., full = FALSE)

\method{fm_basis}{fm_mesh_2d}(x, loc, weights = NULL, derivatives = NULL, ..., full = FALSE)

\method{fm_basis}{fm_mesh_3d}(x, loc, weights = NULL, ..., full = FALSE)

\method{fm_basis}{fm_lattice_2d}(x, loc, weights = NULL, ..., full = FALSE)

\method{fm_basis}{fm_lattice_Nd}(x, loc, weights = NULL, ..., full = FALSE)

\method{fm_basis}{fm_tensor}(x, loc, weights = NULL, ..., full = FALSE)

\method{fm_basis}{fm_collect}(x, loc, weights = NULL, ..., full = FALSE)

\method{fm_basis}{matrix}(x, ok = NULL, weights = NULL, ..., full = FALSE)

\method{fm_basis}{Matrix}(x, ok = NULL, weights = NULL, ..., full = FALSE)

\method{fm_basis}{list}(x, weights = NULL, ..., full = FALSE)

\method{fm_basis}{fm_basis}(x, ..., full = FALSE)

\method{fm_basis}{fm_evaluator}(x, ..., full = FALSE)
}
\arguments{
\item{x}{An function space object, or other supported object
(\code{matrix}, \code{Matrix}, \code{list})}

\item{\dots}{Passed on to submethods}

\item{full}{logical; if \code{TRUE}, return a \code{fm_basis} object, containing at
least a projection matrix \code{A} and logical vector \code{ok} indicating which
evaluations are valid. If \code{FALSE}, return only the projection matrix \code{A}.
Default is \code{FALSE}.}

\item{loc}{A location/value information object (\code{numeric}, \code{matrix}, \code{sf},
\code{fm_bary}, etc, depending on the class of \code{x})}

\item{weights}{Optional weight vector to apply (from the left, one
weight for each row of the basis matrix)}

\item{derivatives}{If non-NULL and logical, include derivative matrices
in the output. Forces \code{full = TRUE}.}

\item{ok}{numerical of length \code{NROW(x)}, indicating which rows of \code{x} are
valid/successful basis evaluations. If \code{NULL}, inferred as
\code{rep(TRUE, NROW(x))}.}
}
\value{
A \code{sparseMatrix} object (if \code{full = FALSE}), or a \code{fm_basis} object
(if \code{full = TRUE} or \code{isTRUE(derivatives)}). The \code{fm_basis} object contains
at least the projection matrix \code{A} and logical vector \code{ok}; If \code{x_j}
denotes the latent basis coefficient for basis function \code{j}, the field is
defined as \verb{u(loc_i)=sum_j A_ij x_j} for all \code{i} where \code{ok[i]} is \code{TRUE},
and \code{u(loc_i)=0.0} where \code{ok[i]} is \code{FALSE}.
}
\description{
Computes the basis mapping matrix between a function space on a
mesh, and locations.
}
\section{Methods (by class)}{
\itemize{
\item \code{fm_basis(fm_mesh_1d)}: If \code{derivatives=TRUE}, the \code{fm_basis} object contains
additional derivative weight matrices, \code{d1A} and \code{d2A}, \verb{du/dx(loc_i)=sum_j dx_ij w_i}.

\item \code{fm_basis(fm_mesh_2d)}: If \code{derivatives=TRUE}, additional derivative weight
matrices are included in the \code{full=TRUE} output: Derivative weight matrices
\code{dx}, \code{dy}, \code{dz}; \verb{du/dx(loc_i)=sum_j dx_ij w_i}, etc.

\item \code{fm_basis(fm_mesh_3d)}: \code{fm_mesh_3d} basis functions.

\item \code{fm_basis(fm_lattice_2d)}: \code{fm_lattice_2d} bilinear basis functions.

\item \code{fm_basis(fm_lattice_Nd)}: \code{fm_lattice_Nd} multilinear basis functions.

\item \code{fm_basis(fm_tensor)}: Evaluates a basis matrix for a \code{fm_tensor} function
space.

\item \code{fm_basis(fm_collect)}: Evaluates a basis matrix for a \code{fm_collect} function
space. The \code{loc} argument must be a \code{list} or \code{tibble} with elements
\code{loc} (the locations) and \code{index} (the indices into the function space
collection).

\item \code{fm_basis(matrix)}: Creates a new \code{fm_basis} object with elements \code{A} and
\code{ok}, from a pre-evaluated basis matrix, including optional additional
elements in the \code{...} arguments. If a \code{ok} is \code{NULL}, it is inferred as
\code{rep(TRUE, NROW(x))}, indicating that all rows correspond to successful
basis evaluations. If \code{full = FALSE},
returns the matrix unchanged.

\item \code{fm_basis(Matrix)}: Creates a new \code{fm_basis} object with elements \code{A} and
\code{ok}, from a pre-evaluated basis matrix, including optional additional
elements in the \code{...} arguments. If a \code{ok} is \code{NULL}, it is inferred as
\code{rep(TRUE, NROW(x))}, indicating that all rows correspond to successful
basis evaluations. If \code{full = FALSE},
returns the matrix unchanged.

\item \code{fm_basis(list)}: Creates a new \code{fm_basis} object from a plain list
containing at least an element \code{A}. If an \code{ok} element is missing,
it is inferred as \code{rep(TRUE, NROW(x$A))}. If \code{full = FALSE},
extracts the \code{A} matrix.

\item \code{fm_basis(fm_basis)}: If \code{full} is \code{TRUE}, returns \code{x} unchanged, otherwise
returns the \code{A} matrix contained in \code{x}.

\item \code{fm_basis(fm_evaluator)}: Extract \code{fm_basis} information from an \code{fm_evaluator}
object. If \code{full = FALSE}, returns the \code{A} matrix contained in the
\code{fm_basis} object.

}}
\examples{
# Compute basis mapping matrix
dim(fm_basis(fmexample$mesh, fmexample$loc))
print(fm_basis(fmexample$mesh, fmexample$loc, full = TRUE))

# From precomputed `fm_bary` information:
bary <- fm_bary(fmexample$mesh, fmexample$loc)
print(fm_basis(fmexample$mesh, bary, full = TRUE))
}
\seealso{
\code{\link[=fm_raw_basis]{fm_raw_basis()}}
}
