% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctIntegral.R
\name{correctIntegral}
\alias{correctIntegral}
\title{Normalizes Log-Concave Density}
\usage{
correctIntegral(X, mu, a, b, cvh)
}
\arguments{
\item{X}{Set of data points (one sample per row)}

\item{mu}{Mean vector of X that gets added back to X}

\item{a}{Matrix where rows are slopes of hyperplanes}

\item{b}{Vector where entries are offsets of hyperplanes}

\item{cvh}{Matrix where each row is a set of indices of points in X
describing one face of conv(X)}
}
\value{
Normalized hyperplane parameters (for the uncentered \code{X <- X +
  mu}) \item{a, b}{Hyperplane parameters of the normalized density.}
  \item{y}{Vector with values y_i = log(f(X_)) of the normalized density.}
  \item{aSparse, bSparse}{Input hyperplane parameters.}
}
\description{
\code{correctIntegral} normalizes a log-concave density
  parametrized by a set of hyperplane parameters. Works by calculating y =
  log(f(x)) for each data point in X, normalizing y, and then recalculating a
  and b.
}
\examples{
# draw samples from normal distribution
X <- matrix(rnorm(200),100,2) 
# calculate parameters of convex hull of X
r <- calcCvxHullFaces(X)
# draw random parameters of 10 hyperplanes
a <- matrix(runif(10*2),10,2)
b <- runif(10)

# calculate parameters of convex hull of X
params <- correctIntegral(X,rep(0,2),a,b,r$cvh)
}
