% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flist.R
\name{as.flist.list}
\alias{as.flist.list}
\title{Convert a list to a formatting list}
\usage{
\method{as.flist}{list}(x, type = "column", lookup = NULL, simplify = TRUE)
}
\arguments{
\item{x}{List to convert.}

\item{type}{The type of formatting list.  Valid values are 'row' or 'column'.
The default value is 'column'.}

\item{lookup}{A lookup vector.  Used for looking up the format from 
the formatting list.  This parameter is only used for 'row' type 
formatting lists.}

\item{simplify}{Whether to simplify the results to a vector.  Valid values 
are TRUE or FALSE.  Default is TRUE.  If the value is set to FALSE, the 
return type will be a list.}
}
\value{
A formatting list object.
}
\description{
Converts a normal list to a formatting list.  All
other parameters are the same as the \code{flist} function.
}
\details{
To apply more than one formatting object to a vector, use a formatting
list.  There are two types of formatting list: column and row.  The column
type formatting lists applies all formats to all values in the
vector.  The row type formatting list can apply a different format to 
each value in the vector.  

Further, there are two styles of row type list: ordered and lookup.  The
ordered style applies each format in the list to the vector values
in the order specified.  The
ordered style will recycle the formats as needed.  The lookup style 
formatting list uses a lookup to determine which format from the list to
apply to a particular value of the vector.  The lookup column values should
correspond to names on the formatting list.  

Examples of column type and row type formatting lists are given below.
}
\examples{
# Example 1: Create flist from list - column type
lst1 <- list("\%d\%b\%Y", "\%.1f")
fl1  <- as.flist(lst1, type = "column")

# Example 2: Create flist from list - row type
lst2 <- list(lkup = c(A = "Label A", B = "Label B"),
             dec1 = "\%.1f",
             dt1  = "\%d\%b\%Y")
fl2 <- as.flist(lst2, type = "row")
             
}
\seealso{
\code{\link{flist}} function documentation for additional details.

Other flist: 
\code{\link{as.data.frame.fmt_lst}()},
\code{\link{as.flist}()},
\code{\link{as.flist.data.frame}()},
\code{\link{as.flist.fcat}()},
\code{\link{as.flist.tbl_df}()},
\code{\link{flist}()},
\code{\link{is.flist}()},
\code{\link{print.fmt_lst}()},
\code{\link{read.flist}()},
\code{\link{write.flist}()}
}
\concept{flist}
