% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_number.R
\name{plot.factor.number}
\alias{plot.factor.number}
\title{Plot factor number}
\usage{
\method{plot}{factor.number}(x, ...)
}
\arguments{
\item{x}{\code{factor.number} object}

\item{...}{not used}
}
\value{
NULL, printed to console
}
\description{
Plots the eigenvalue ratio or information criteria from a \code{factor.number} object
}
\examples{
library(fnets)
## Alessi, Barigozzi, and Capasso method for restricted models
abc <- factor.number(data.restricted, fm.restricted = TRUE)
print(abc)
plot(abc)

## Eigenvalue ratio method
er <- factor.number(data.restricted, method = "er", fm.restricted = TRUE)
print(er)
plot(er)

## Hallin and Liška method for unrestricted models
hl <- factor.number(data.unrestricted, fm.restricted = FALSE)
print(hl)
plot(hl)
}
\seealso{
\link[fnets]{factor.number}
}
