% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab.R
\name{grab}
\alias{grab}
\title{grab tbl's by name from a foieGras fitted model object}
\usage{
grab(x, what = "fitted", as_sf = TRUE)
}
\arguments{
\item{x}{a foieGras fitted model object}

\item{what}{the tibble to be grabbed; either `fitted`, `predicted`, or
`data` (single letters can be used)}

\item{as_sf}{logical; if FALSE then return a tibble with unprojected lonlat
coordinates, otherwise return an sf tibble}
}
\value{
a tbl with all individual tbl's appended
}
\description{
`grab()` lets you obtain `fitted`, `predicted`, or `data` tbl's
from a compound tbl created when fitting to multiple individual data sets.
The specified tbl's are appended to a single output tbl.
}
\examples{
## load example foieGras fit object (to save time)
data(fit)
## grab predicted values as an unprojected tibble
preds <- grab(fit, what = "p", as_sf = FALSE)
}
