% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocct.R
\name{vocct}
\alias{vocct}
\title{Convertion and analysis of VOC concentrations}
\usage{
vocct(
  df,
  unit = "ppbv",
  t = 25,
  p = 101.325,
  stcd = FALSE,
  sortd = TRUE,
  chn = FALSE,
  bvoc = TRUE
)
}
\arguments{
\item{df}{dataframe contains time series.}

\item{unit}{unit for VOC concentration. A character vector from these options: "ugm" or "ppbv". "ugm" means ug/m3. "ppbv" means part per billion volumn.}

\item{t}{Temperature, in Degrees Celsius, used to convert data in 
micrograms per cubic meter to standard conditions 
(25 Degrees Celsius, 101.325 kPa). By default, t equals to 25 Degrees Celsius.}

\item{p}{Pressure, in kPa, used to convert data in micrograms per cubic meter 
to standard conditions (25 Degrees Celsius, 101.325 kPa). 
By default, p equals to 101.325 kPa.}

\item{stcd}{logical. Does it output results in standard conditions? The default vaule is FALSE.}

\item{sortd}{logical value. It determines whether the VOC species
are sorted or not. By default, sortd has value "TRUE".
If TRUE, VOC species in time series will be arranged according to VOC group,
 relative molecular weight, and MIR value.}

\item{chn}{logical. Dose colnames present as Chinese? The default vaule is FALSE.}

\item{bvoc}{logical. Whether you want to list BVOC as a separate VOC group? The default vaule is TRUE.}
}
\value{
a list contains 9 tables:
MW_Result: the matched Molecular Weight (MW) value result;
Con_ugm: the time series of VOC mass concentration by species;
Con_ugm_stat: the statistics of VOC mass concentration by species;
Con_ugm_group: the time series of VOC mass concentration classified by groups;
Con_ugm_group_stat: the statistics of VOC mass concentrationaccording to major groups;
Con_ppbv: time series of VOC volume concentration by species;
Con_ppbv_stat: the statistics of VOC volume concentration by species;
Con_ppbv_group: the time series of VOC volume concentration according to major groups;
Con_ppbv_group_stat: the time series of VOC volume concentration classified by groups.
}
\description{
convert unit of VOCs between micrograms per cubic meter (ugm) and parts
per billion by volume (ppbv); conduct statistics of VOC concentrations.
Note: for Chinese VOC name, please also use English punctuation.
}
\details{
The CAS number was matched for each VOC speices (from column name), and the
Molecular Weight (MW) value and Maximum Incremental Reactivity (MIR) value are matched through the CAS number and used for time series calculation. \cr
The MIR value comes from "Carter, W. P. (2009). Updated maximum incremental
reactivity scale and hydrocarbon bin reactivities for regulatory applications.
California Air Resources Board Contract, 2009, 339" (revised January 28, 2010).
}
\examples{
voc_con=vocct(voc)
summary(voc_con)
}
