% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_cross.R
\name{fct_cross}
\alias{fct_cross}
\title{Combine levels from two or more factors to create a new factor}
\usage{
fct_cross(..., sep = ":", keep_empty = FALSE)
}
\arguments{
\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Additional factors
or character vectors.}

\item{sep}{A character string to separate the levels}

\item{keep_empty}{If TRUE, keep combinations with no observations as levels}
}
\value{
The new factor
}
\description{
Computes a factor whose levels are all the combinations of the levels of the input factors.
}
\examples{
fruit <- factor(c("apple", "kiwi", "apple", "apple"))
colour <- factor(c("green", "green", "red", "green"))
eaten <- c("yes", "no", "yes", "no")
fct_cross(fruit, colour)
fct_cross(fruit, colour, eaten)
fct_cross(fruit, colour, keep_empty = TRUE)
}
