% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.R
\name{f}
\alias{f}
\title{Compute \eqn{f(\delta)} for a tvAR(p) process}
\usage{
f(which.deltas, p_max, h, T, Ns, m, a, sigma)
}
\arguments{
\item{which.deltas}{vector containing the \eqn{\delta}'s for which to
to compute \eqn{f(\delta)},}

\item{p_max}{parameter \eqn{p_{\max}},}

\item{h}{parameter \eqn{h},}

\item{T}{parameter \eqn{T},}

\item{Ns}{a vector containing the elements of the set
\eqn{\mathcal{N}},}

\item{m}{parameter \eqn{m},}

\item{a}{a list of real-valued functions, specifying the
coefficients of the tvAR(p) process,}

\item{sigma}{a positive-valued function, specifying the variance
of the innovations of the tvAR(p) process,}
}
\value{
Returns     a vector with the values \eqn{f(\delta)}, as defined in
                    (10) of Kley et al (2016), for each \eqn{\delta} in
										 \code{which.delta}.
}
\description{
This functions computes the quantity \eqn{f(\delta)} defined in (10) of
Kley et al (2016) when the underlying process follows an tvAR(p) process.
Recall that, to apply Theorem 3.1 in Kley et al (2016), the function
\eqn{f(\delta)} is required to be positive, which can be verified with the
numbers returned from this function.
The function returns a vector with elements \eqn{f(\delta)} 
for each \eqn{\delta} in \code{which.deltas}, with \eqn{f(\delta)}
defined as  
\deqn{f(\delta) := \min_{p_1,p_2 = 0, \ldots, p_{\max}} \min_{N \in \mathcal{N}} \Big| {\rm MSPE}_{s_1/T,m/T}^{(p_1,h)}(\frac{s_1}{T}) - (1+\delta) \cdot {\rm MSPE}_{N/T,m/T}^{(p_2,h)}(\frac{s_1}{T}) \Big|, \quad \delta \geq 0}
where \eqn{T, m, p_{\max}, h} are positive integers,
\eqn{\mathcal{N} \subset \{p_{\max}+1, \ldots, T-m-h\}}, and \eqn{s_1 := T-m-h+1}.
}
\details{
The function \eqn{{\rm MSPE}_{\Delta_1, \Delta_2}^{(p,h)}(u)} is defined, for real-valued \eqn{u} and
\eqn{\Delta_1, \Delta_2 \geq 0}, in terms of the second order properties of the process:
\deqn{{\rm MSPE}_{\Delta_1, \Delta_2}^{(p,h)}(u) := \int_0^1 g^{(p,h)}_{\Delta_1}\Big( u + \Delta_2 (1-x) \Big) {\rm d}x,}
with \eqn{g^{(0,h)}_{\Delta}(u) := \gamma_0(u)} and, for \eqn{p = 1, 2, \ldots},
\deqn{g^{(p,h)}_{\Delta}(u) := \gamma_0(u) - 2 \big( v_{\Delta}^{(p,h)}(u) \big)' \gamma_0^{(p,h)}(u) + \big( v_{\Delta}^{(p,h)}(u) \big)' \Gamma_0^{(p)}(u) v_{\Delta}^{(p,h)}(u)}
\deqn{\gamma_0^{(p,h)}(u) := \big( \gamma_h(u), \ldots, \gamma_{h+p-1}(u) \big)',}
where
\deqn{v^{(p,h)}_{\Delta}(u) := e'_1 \big( e_1 \big( a_{\Delta}^{(p)}(t) \big)' + H \big)^h,}
with \eqn{e_1} and \eqn{H} defined in the documentation of \code{\link{predCoef}} and,
for every real-valued \eqn{u} and \eqn{\Delta \geq 0},
\deqn{a^{(p)}_{\Delta}(u) := \Gamma^{(p)}_{\Delta}(u)^{-1} \gamma^{(p)}_{\Delta}(u),}
where
\deqn{\gamma^{(p)}_{\Delta}(u) := \int_0^1 \gamma^{(p)}(u+\Delta (x-1)) {\rm d}x, \quad \gamma^{(p)}(u) := [\gamma_1(u)\;\ldots\;\gamma_p(u)]',}
\deqn{\Gamma^{(p)}_{\Delta}(u) := \int_0^1 \Gamma^{(p)}(u+\Delta (x-1)) {\rm d}x, \quad \Gamma^{(p)}(u) := (\gamma_{i-j}(u);\,i,j=1,\ldots,p).}

The local autocovariances \eqn{\gamma_k(u)} are defined as the lag-\eqn{k}
autocovariances of an AR(p) process which has coefficients
\eqn{a_1(u), \ldots, a_p(u)} and innovations with variance \eqn{\sigma(u)^2},
because the underlying model is assumed to be tvAR(p)  
\deqn{Y_{t,T} = \sum_{j=1}^p a_j(t/T) Y_{t-j,T} + \sigma(t/T) \varepsilon_{t},}
where \eqn{a_1, \ldots, a_p} are real valued functions (defined on \eqn{[0,1]}) and \eqn{\sigma} is a
positive function (defined on \eqn{[0,1]}).
}
\examples{
\dontrun{
## because computation is quite time-consuming.
T <- 100
a <- list( function(u) {return(0.8+0.19*sin(4*pi*u))} )
sigma <- function (u) {return(1)}

Ns <- seq( floor((T/2)^(4/5)), floor(T^(4/5)),
           ceiling((floor(T^(4/5)) - floor((T/2)^(4/5)))/25) )
which.deltas <- c(0, 0.01, 0.05, 0.1, 0.15, 0.2, 0.4, 0.6)
P_max <- 7
H <- 1
m <- floor(T^(.85)/4)

# now replicate some results from Table 4 in Kley et al (2016)
f( which.deltas, P_max, h = 1, T, Ns, m, a, sigma )
f( which.deltas, P_max, h = 5, T, Ns, m, a, sigma )
}
}

