% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss_diffs.R
\name{ss_diffs}
\alias{ss_diffs}
\title{Systematic Sampling}
\usage{
ss_diffs(df, Yi, plot_area, total_area, age = NA, .groups = NA,
  alpha = 0.05, error = 10, dec_places = 4, tidy = TRUE)
}
\arguments{
\item{df}{a data frame.}

\item{Yi}{Quoted name of the volume variable, or other variable one desires to evaluate, in quotes.}

\item{plot_area}{Quoted name of the plot area variable, or a numeric vector with the plot area value. The plot area value must be in square meters.}

\item{total_area}{Quoted name of the total area variable, or a numeric vector with the total area value.The total area value must be in hectares.}

\item{age}{Optional parameter. Quoted name of the age variable. Calculates the average age supplied. \code{NA}.}

\item{.groups}{Optional argument. Quoted name(s) of additional grouping variable(s) that, if supplied, will be used to run multiple surveys, one for each level. 
If this argument is \code{NA}, the defined groups in the data frame will be used, if they exist. Default: \code{NA}.}

\item{alpha}{Numeric value for the significance value used in the t-student estimation. Default: \code{0.05}.}

\item{error}{Numeric value for the minimum admitted error value in the survey, in percentage. Default: \code{10}.}

\item{dec_places}{Numeric value for the number of decimal places to be used in the output tables. Default: \code{4}.}

\item{tidy}{Boolean value that defines if the output tables should be tidied up or not. Default: \code{TRUE}.}
}
\value{
A data frame with the sampling results.
}
\description{
Function for processing forest inventory data using systematic sampling.
}
\details{
This function allows the user to processes inventory data using simple random sampling for finite or infinite populations.
It's possible to run multiple sampling analysis using a factor variable indicated in the \code{.groups}() parameter.
}
\examples{
library(forestmangr)
data("exfm2")
data("exfm5")

# We're trying to run a inventory for an area This data was collected systematically,
# but we'll try to run the data using simple random sampling, 
# to show the difference between the two methods:
sprs(exfm5,  "VWB", "PLOT_AREA", "TOTAL_AREA")

# We get a 22\% error value. Now, we run this same data
# considering the data as a systematic inventory, using the
# successive differences method:
ss_diffs(exfm5,  "VWB", "PLOT_AREA", "TOTAL_AREA")

# The error was significantly lowered,

# Area Values can be numeric;
ss_diffs(exfm5,  "VWB", 200, 18)

# Here we run a systematic sampling inventory for each forest subdivision, 
# using the STRATA variable as a group variable:
ss_diffs(exfm2,  "VWB", "PLOT_AREA", "STRATA_AREA",.groups = "STRATA")

}
\references{
Campos, J. C. C. and Leite, H. G. (2017) Mensuracao Florestal: Perguntas e Respostas. 5a. Vicosa: UFV.

Soares, C. P. B., Paula Neto, F. and Souza, A. L. (2012) Dendrometria e Inventario Florestal. 2nd ed. Vicosa: UFV.
}
\seealso{
other sampling functions: 
  \code{\link{sprs}} for Simple Random Sampling, and
  \code{\link{strs}} for stratified random sampling, and
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
\keyword{Sampling}
\keyword{Systematic}
