% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_curve.R
\name{guide_curve}
\alias{guide_curve}
\title{Get the guide curve plot for growth and yield analysis of inventory data}
\usage{
guide_curve(
  df,
  dh,
  age,
  age_index,
  n_class = 4,
  model = "Schumacher",
  start_chap = c(b0 = 23, b1 = 0.03, b2 = 1.3),
  start_bailey = c(b0 = 3, b1 = -130, b2 = 1.5),
  round_classes = FALSE,
  font = "serif",
  gray_scale = TRUE,
  output = "plot"
)
}
\arguments{
\item{df}{A data frame.}

\item{dh}{Quoted name for the dominant height variable.}

\item{age}{Quoted name for the age variable.}

\item{age_index}{Numeric value for the age index.}

\item{n_class}{Numeric value for the number of classes used to divide the data. Default \code{4}.}

\item{model}{model used to fit dh as a function of age. The models available are \code{"Schumacher"}, \code{"Curtis"}, \code{"Chapman-Richards"} and \code{"Bailey-Clutter"}. Default: \code{"Schumacher"}.}

\item{start_chap}{Numeric vector with the start values for the Chapman-Richards model. This must be a named vector, with b0, b1 and b2 as parameter names. Default: \code{c(b0=23, b1=0.03, b2 = 1.3)}.}

\item{start_bailey}{Numeric vector with the start values for the Bailey-Clutter model. This must be a named vector, with b0, b1 and b2 as parameter names. Default: \code{c( b0=3, b1=-130, b2 = 1.5)}.}

\item{round_classes}{If \code{TRUE}, class values will be rounded to the nearest 5. Default \code{TRUE}.}

\item{font}{Type of font used in the plot. Default: \code{"serif"}.}

\item{gray_scale}{If \code{TRUE}, the plot will be rendered in a gray scale. Default: \code{"TRUE"}.}

\item{output}{Type of output the function should return. This can either be \code{"plot"}, for the guide curve plot, \code{"table"}, for a data frame with the data used on the guide curve plot, and \code{"full"} for a list with 2 ggplot2 objects, one for residual plot and other for plot curves, a lm object for the regression, a data frame with quality of fit variables, the dominant height index, the class table used, and the table used for the guide curve plot. Default \code{"plot"}.}
}
\value{
A data frame, a ggplot object, or a list, varying according to the \code{"output"} argument.
}
\description{
Get the guide curve for growth and yield analysis of inventory data
using the factor method, and different statistical models.
}
\examples{
data("exfm14")
exfm14

# To get a guide curve plot for this data, we simply need to input
# dominant height and age variables, age index, and number of classes to be used:
guide_curve(exfm14, "dh", "age", 72, 5)

# if we want to get the table used to get the plot, we can choose the output "table":
guide_curve(exfm14, "dh", "age", 72, 5, output = "table")

# Other models are available for use, such as Curtis, Chapman Richards, and Bailey:
# CR and BC models are non linear, and thus need start values. There are default values,
# but they may fail, depending on the data used, so it's recommended to try start values that
# are ideal for the data used:
guide_curve(exfm14, "dh", "age", 72, 5,
 model = "Chapman-Richards", start_chap = c(b0=23, b1=0.03, b2 = 1.3))

# Or, to get more information on the analysis, such as details on the regression,
# bias, rmse, plot for residuals and more (cpu taxing):
\dontrun{
guide_curve(exfm14, "dh", "age", 72, 5, output = "full")
}
}
\author{
Sollano Rabelo Braga \email{sollanorb@gmail.com}
}
