% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fp_decorate_graph.R
\name{fp_decorate_graph}
\alias{fp_decorate_graph}
\title{Decorate the graph}
\usage{
fp_decorate_graph(
  x,
  box = NULL,
  right_bottom_txt = NULL,
  left_bottom_txt = NULL,
  right_top_txt = NULL,
  left_top_txt = NULL,
  grid = NULL,
  graph.pos = NULL
)
}
\arguments{
\item{x}{The forestplot object}

\item{box}{Decorate the graph by framing it in a box. If provided \code{TRUE} it
will simply frame the graph in a black box. If you provide a string it is
assumed to be the color of the graph. Acceptable arguments are also \code{gpar()}
and a \code{grob} object to draw.}

\item{right_bottom_txt}{Text to appear at the right bottom of the graph. Can
be decorated fp_txt_* functions.}

\item{left_bottom_txt}{Text to appear at the left bottom of the graph. Can
be decorated fp_txt_* functions.}

\item{right_top_txt}{Text to appear at the right top of the graph. Can
be decorated fp_txt_* functions.}

\item{left_top_txt}{Text to appear at the left top of the graph. Can
be decorated fp_txt_* functions.}

\item{grid}{If you want a discrete gray dashed grid at the level of the
ticks you can set this parameter to \code{TRUE}. If you set the parameter
to a vector of values lines will be drawn at the corresponding positions.
If you want to specify the \code{\link[grid]{gpar}} of the lines then either
directly pass a \code{\link[grid]{gpar}} object or set the gp attribute e.g.
\code{attr(line_vector, "gp") <- \link[grid]{gpar}(lty = 2, col = "red")}}

\item{graph.pos}{The position of the graph element within the table of text. The
position can be \code{1-(ncol(labeltext) + 1)}. You can also choose set the position
to \code{"left"} or \code{"right"}.}
}
\value{
The forestplot object with the extended decoration
}
\description{
Decorate the graph
}
\examples{
base_data <- tibble::tibble(mean  = c(0.578, 0.165, 0.246, 0.700, 0.348, 0.139, 1.017),
                            lower = c(0.372, 0.018, 0.072, 0.333, 0.083, 0.016, 0.365),
                            upper = c(0.898, 1.517, 0.833, 1.474, 1.455, 1.209, 2.831),
                            study = c("Auckland", "Block", "Doran", "Gamsu",
                                      "Morrison", "Papageorgiou", "Tauesch"),
                            deaths_steroid = c("36", "1", "4", "14", "3", "1", "8"),
                            deaths_placebo = c("60", "5", "11", "20", "7", "7", "10"),
                            OR = c("0.58", "0.16", "0.25", "0.70", "0.35", "0.14", "1.02"))

base_data |>
  forestplot(labeltext = c(study, deaths_steroid, deaths_placebo, OR),
             clip = c(0.1, 2.5),
             xlog = TRUE) |>
  fp_add_header(study = c("", "Study"),
                deaths_steroid = c("Deaths", "(steroid)"),
                deaths_placebo = c("Deaths", "(placebo)"),
                OR = c("", "OR")) |>
  fp_set_style(box = "royalblue",
               line = "darkblue",
               summary = gpar(fill = "royalblue", clr = "black"),
               txt_gp = fpTxtGp(label = gpar(fontfamily = "mono"))) |>
  fp_decorate_graph(box = "lightgray",
                    right_bottom_txt = fp_txt_gp("RB", gp = gpar(cex = .5)),
                    left_bottom_txt = fp_txt_gp("LB", gp = gpar(cex = .5)),
                    right_top_txt = "RT",
                    left_top_txt = "LT")
}
\seealso{
Other graph modifiers: 
\code{\link{fp_add_lines}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()},
\code{\link{fp_set_zebra_style}()}

Other forestplot functions: 
\code{\link{forestplot}()},
\code{\link{fpColors}()},
\code{\link{fpDrawNormalCI}()},
\code{\link{fpLegend}()},
\code{\link{fpShapesGp}()},
\code{\link{fp_add_lines}()},
\code{\link{fp_insert_row}()},
\code{\link{fp_set_style}()},
\code{\link{fp_set_zebra_style}()}
}
\concept{forestplot functions}
\concept{graph modifiers}
