% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{num_rep_cols}
\alias{num_rep_cols}
\alias{num_rep_cols,ANY-method}
\alias{num_rep_cols,MatrixPrintForm-method}
\alias{num_rep_cols<-}
\alias{num_rep_cols<-,ANY-method}
\alias{num_rep_cols<-,MatrixPrintForm-method}
\title{Number of repeated columns}
\usage{
num_rep_cols(obj)

\S4method{num_rep_cols}{ANY}(obj)

\S4method{num_rep_cols}{MatrixPrintForm}(obj)

num_rep_cols(obj) <- value

\S4method{num_rep_cols}{ANY}(obj) <- value

\S4method{num_rep_cols}{MatrixPrintForm}(obj) <- value
}
\arguments{
\item{obj}{(\code{ANY})\cr a table-like object.}

\item{value}{(\code{numeric(1)})\cr the new number of columns to repeat.}
}
\value{
An integer.
}
\description{
When called on a table-like object using the formatters framework, this method returns the
number of columns which are mandatorily repeated after each horizontal pagination.
}
\details{
Absent a class-specific method, this function returns 0, indicating no always-repeated columns.
}
\note{
This number \emph{does not} include row labels, the repetition of which is handled separately.
}
\examples{
mpf <- basic_matrix_form(mtcars)
num_rep_cols(mpf)
lmpf <- basic_listing_mf(mtcars)
num_rep_cols(lmpf)

}
