% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DW_Server.R
\name{DW_init_state}
\alias{DW_init_state}
\title{Initialize DW Module State}
\usage{
DW_init_state(FM_yaml_file, MOD_yaml_file, id, id_UD, session)
}
\arguments{
\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id}{Shiny module ID}

\item{id_UD}{ID string for the upload data module used to handle uploads or
the name of the list element in react_state where the data set is stored.}

\item{session}{Shiny session variable
module (\code{NULL})}
}
\value{
list containing an empty DW state
}
\description{
Creates a list of the initialized module state
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = DW_test_mksession(session=list())
session = sess_res$session
input   = sess_res$input

state = DW_init_state(
   FM_yaml_file  = system.file(package = "formods",
                               "templates",
                               "formods.yaml"),
   MOD_yaml_file = system.file(package = "formods",
                               "templates",
                               "DW.yaml"),
   id              = "DW",
   id_UD           = "UD",
   session         = session)

state
}
