% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formulize.R
\name{formulize}
\alias{formulize}
\title{Create a formula/recipe interface to a modelling method}
\usage{
formulize(f)
}
\arguments{
\item{f}{A function with a matrix/vector interface. Assumes data is passed
to this function via some combination of arguments \code{x}, \code{X},
\code{y}, \code{Y}}
}
\value{
The same function, wrapped to have formula/dataframe and
  recipe/dataframe interfaces.
}
\description{
Create a formula/recipe interface to a modelling method
}
\examples{

library(glmnet)

glmnet_form <- formulize(cv.glmnet)

model <- glmnet_form(mpg ~ drat * hp - 1, mtcars)
predict(model, head(mtcars))

}
