\name{cluster.stats}
\alias{cluster.stats}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Cluster validation statistics}
\description{
  Computes a number of distance based statistics, which can be used for cluster
  validation, comparison between clusterings and decision about
  the number of clusters: cluster sizes, cluster diameters,
  average distances within and between clusters, cluster separation,
  biggest within cluster gap, 
  average silhouette widths, the Calinski and Harabasz index,
  a Pearson version of
  Hubert's gamma coefficient, the Dunn index and two indexes
  to assess the similarity of two clusterings, namely the corrected Rand
  index and Meila's VI.
}
\usage{
cluster.stats(d = NULL, clustering, alt.clustering = NULL,
                           noisecluster=FALSE,
                              silhouette = TRUE, G2 = FALSE, G3 = FALSE,
                              wgap=TRUE, sepindex=TRUE, sepprob=0.1,
                              sepwithnoise=TRUE,
                              compareonly = FALSE,
                              aggregateonly = FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{d}{a distance object (as generated by \code{dist}) or a distance
    matrix between cases.}
  \item{clustering}{an integer vector of length of the number of cases,
    which indicates a clustering. The clusters have to be numbered
    from 1 to the number of clusters.}
  \item{alt.clustering}{an integer vector such as for
    \code{clustering}, indicating an alternative clustering. If provided, the
    corrected Rand index and Meila's VI for \code{clustering}
    vs. \code{alt.clustering} are computed.}
  \item{noisecluster}{logical. If \code{TRUE}, it is assumed that the
    largest cluster number in \code{clustering} denotes a 'noise
    class', i.e. points that do not belong to any cluster. These points
    are not taken into account for the computation of all functions of
    within and between cluster distances including the validation
    indexes.} 
  \item{silhouette}{logical. If \code{TRUE}, the silhouette statistics
    are computed, which requires package \code{cluster}.}
  \item{G2}{logical. If \code{TRUE}, Goodman and Kruskal's index G2
    (cf. Gordon (1999), p. 62) is computed. This executes lots of
    sorting algorithms and can be very slow (it has been improved
    by R. Francois - thanks!)}
  \item{G3}{logical. If \code{TRUE}, the index G3
    (cf. Gordon (1999), p. 62) is computed. This executes \code{sort}
    on all distances and can be extremely slow.}
  \item{wgap}{logical. If \code{TRUE}, the widest within-cluster gaps
    (largest link in within-cluster minimum spanning tree) are
    computed. This is used for finding a good number of clusters in
    Hennig (2013).}
  \item{sepindex}{logical. If \code{TRUE}, a separation index is
    computed, defined based on the distances for every point to the
    closest point not in the same cluster. The separation index is then
    the mean of the smallest proportion \code{sepprob} of these. This
    allows to formalise separation less sensitive to a single or a few
    ambiguous points. The output component corresponding to this is
    \code{sindex}, not \code{separation}! This is used for finding a
    good number of clusters in Hennig (2013).
  }
  \item{sepprob}{numerical between 0 and 1, see \code{sepindex}.}
  \item{sepwithnoise}{logical. If \code{TRUE} and \code{sepindex} and
    \code{noisecluster} are both \code{TRUE}, the noise points are
    incorporated as cluster in the separation index computation. Also
    they are taken into account for the computation for the minimum
    cluster separation regardless of \code{sepindex}.} 
  \item{compareonly}{logical. If \code{TRUE}, only the corrected Rand index
    and Meila's VI are
    computed and given out (this requires \code{alt.clustering} to be
    specified).}
  \item{aggregateonly}{logical. If \code{TRUE} (and not
    \code{compareonly}), no clusterwise but only aggregated information
    is given out (this cuts the size of the output down a bit).}

}

\note{
  Because \code{cluster.stats} processes a full dissimilarity matrix, it
  isn't suitable for large data sets. You may consider
  \code{\link{distcritmulti}} in that case.
}

\value{
  \code{cluster.stats} returns a list containing the components
  \code{n, cluster.number, cluster.size,  min.cluster.size, noisen,
    diameter,
    average.distance, median.distance, separation, average.toother,
    separation.matrix, average.between, average.within,
    n.between, n.within, within.cluster.ss, clus.avg.silwidths, avg.silwidth,
    g2, g3, pearsongamma, dunn, entropy, wb.ratio, ch,
    corrected.rand, vi} except if \code{compareonly=TRUE}, in which case
    only the last two components are computed.

  \item{n}{number of cases.}
  \item{cluster.number}{number of clusters.}
  \item{cluster.size}{vector of cluster sizes (number of points).}
  \item{min.cluster.size}{size of smallest cluster.}
  \item{noisen}{number of noise points, see argument \code{noisecluster}
    (\code{noisen=0} if \code{noisecluster=FALSE}).}
  \item{diameter}{vector of cluster diameters (maximum within cluster
    distances).}
  \item{average.distance}{vector of clusterwise
    within cluster average distances.}
  \item{median.distance}{vector of clusterwise
    within cluster distance medians.}
  \item{separation}{vector of clusterwise minimum distances of a point
    in the cluster to a point of another cluster.}
  \item{average.toother}{vector of clusterwise average distances of a point
    in the cluster to the points of other clusters.}
  \item{separation.matrix}{matrix of separation values between all pairs
    of clusters.}
  \item{ave.between.matrix}{matrix of mean dissimilarities between
  points of every pair of clusters.}
  \item{average.between}{average distance between clusters.}
  \item{average.within}{average distance within clusters.}
  \item{n.between}{number of distances between clusters.}
  \item{n.within}{number of distances within clusters.}
  \item{max.diameter}{maximum cluster diameter.}
  \item{min.separation}{minimum cluster separation.}
  \item{within.cluster.ss}{a generalisation of the within clusters sum
    of squares (k-means objective function), which is obtained if
    \code{d} is a Euclidean distance matrix.  For general distance
    measures, this is half
    the sum of the within cluster squared dissimilarities divided by the
    cluster size.}
  \item{clus.avg.silwidths}{vector of cluster average silhouette
    widths. See
    \code{\link{silhouette}}.}
  \item{avg.silwidth}{average silhouette
    width. See
    \code{\link{silhouette}}.}
  \item{g2}{Goodman and Kruskal's Gamma coefficient. See Milligan and
    Cooper (1985), Gordon (1999, p. 62).}
  \item{g3}{G3 coefficient. See Gordon (1999, p. 62).}
  \item{pearsongamma}{correlation between distances and a
    0-1-vector where 0 means same cluster, 1 means different clusters.
    "Normalized gamma" in Halkidi et al. (2001).}
  \item{dunn}{minimum separation / maximum diameter. Dunn index, see
    Halkidi et al. (2002).}
  \item{dunn2}{minimum average dissimilarity between two cluster /
    maximum average within cluster dissimilarity, another version of
    the family of Dunn indexes.} 
  \item{entropy}{entropy of the distribution of cluster memberships,
    see Meila(2007).}
  \item{wb.ratio}{\code{average.within/average.between}.}
  \item{ch}{Calinski and Harabasz index (Calinski and Harabasz 1974,
    optimal in Milligan and Cooper 1985; generalised for dissimilarites
    in Hennig and Liao 2010).}
  \item{cwidegap}{vector of widest within-cluster gaps.}
  \item{widestgap}{widest within-cluster gap.}
  \item{sindex}{separation index, see argument \code{sepindex}.}
  \item{corrected.rand}{corrected Rand index (if \code{alt.clustering}
    has been specified), see Gordon (1999, p. 198).}
  \item{vi}{variation of information (VI) index (if \code{alt.clustering}
    has been specified), see Meila (2007).}
}
\references{
    Calinski, T., and Harabasz, J. (1974) A Dendrite Method for Cluster 
Analysis, \emph{Communications in Statistics}, 3, 1-27.

  Gordon, A. D. (1999) \emph{Classification}, 2nd ed. Chapman and Hall.

  Halkidi, M., Batistakis, Y., Vazirgiannis, M. (2001) On Clustering
  Validation Techniques, \emph{Journal of Intelligent Information
    Systems}, 17, 107-145.

  Hennig, C. and Liao, T. (2010) Comparing latent class and
  dissimilarity based clustering for mixed type variables with
  application to social stratification. Research report no. 308,
  Department of Statistical Science, UCL.
  \url{http://www.ucl.ac.uk/Stats/research/reports/psfiles/rr308.pdf}.
  Revised version accepted for publication
  by Journal of the Royal Statistical Society
  Series C.

  Hennig, C. (2013) How many bee species? A case study in
determining the number of clusters. To appear in Proceedings of
GfKl-2012, Hildesheim.
  
    Kaufman, L. and Rousseeuw, P.J. (1990). "Finding Groups in Data:
  An Introduction to Cluster Analysis". Wiley, New York.
  
  Meila, M. (2007) Comparing clusterings?an information based distance,
  \emph{Journal of Multivariate Analysis}, 98, 873-895.
  
  Milligan, G. W. and Cooper, M. C. (1985) An examination of procedures
  for determining the number of clusters. \emph{Psychometrika}, 50, 159-179.
}
\author{Christian Hennig
  \email{c.hennig@ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche/}
}
\seealso{
  \code{\link{silhouette}}, \code{\link{dist}}, \code{\link{calinhara}},
  \code{\link{distcritmulti}}.
  \code{\link{clusterboot}} computes clusterwise stability statistics by
  resampling.
}
\examples{  
  set.seed(20000)
  face <- rFace(200,dMoNo=2,dNoEy=0,p=2)
  dface <- dist(face)
  complete3 <- cutree(hclust(dface),3)
  cluster.stats(dface,complete3,
                alt.clustering=as.integer(attr(face,"grouping")))
  
}
\keyword{cluster}% at least one, from doc/KEYWORDS
\keyword{multivariate}



