% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build}
\alias{build}
\title{Automatic build of the anomaly detection model}
\usage{
build(data, func = FPI, initial_support = 0.5, top_outlier_threshold = 3,
  iteration_timeout = 10)
}
\arguments{
\item{data}{\code{data.frame} or \code{transactions} from \code{arules} with input data}

\item{func}{function name of the method that will be use during the automatic build}

\item{initial_support}{initial maximum support}

\item{top_outlier_threshold}{number of top unique outliers as a stopping condition}

\item{iteration_timeout}{timeout of one iteration}
}
\value{
model of outlier detection
}
\description{
An experimental implementataion that automatically builds an anomaly detection model
}
\examples{
# simple build with default parameters (FPI method)
library("fpmoutliers")
data("iris")
model <- fpmoutliers::build(iris[sample(nrow(iris), 5),])

\donttest{
# using other anomaly detection methods for the automatic build (e.g. LFPOF)
library("fpmoutliers")
data("iris")
model <- fpmoutliers::build(iris[sample(nrow(iris), 5),], func=LFPOF)
}
}
