% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.emfrail.R
\name{plot.emfrail}
\alias{plot.emfrail}
\title{Plots for emfrail objects}
\usage{
\method{plot}{emfrail}(x, type = c("hist", "hr", "pred"), newdata = NULL,
  lp = NULL, strata = NULL, quantity = "cumhaz",
  type_pred = c("conditional", "marginal"), conf_int = "adjusted",
  individual = FALSE, ...)
}
\arguments{
\item{x}{\code{emfrail} object, typically result of \code{emfrail()}}

\item{type}{One (or more) of \code{hist} for a histogram of the estimated frailty values,
\code{hr} for a plot of the conditional and marginal hazard ratio between two cases and
\code{pred} for the predicted conditional and marginal cumulative hazard or survival for one case}

\item{newdata}{A \code{data.frame} with values of the covariates. For \code{type == "hr"} the hazard ratio
between the first two rows of \code{newdata} is calculated. For \code{type == "pred"} the prediction
for the first row of \code{newdata} is calculated.}

\item{lp}{A numeric vector of values of the linear predictor, each corresponding to a case. For \code{type == "hr"} the hazard ratio
between the first two values of \code{lp} is calculated. For \code{type == "pred"} the prediction
for the first value of \code{lp} is calculated.}

\item{strata}{The name of the strata (if applicable) for which the prediction should be made.}

\item{quantity}{For \code{type == "pred"} the predicted quantity; see \code{quantity} in \code{\link{predict.emfrail}}}

\item{type_pred}{For \code{type == "pred"} the type of predicted quantity; see \code{type} in \code{\link{predict.emfrail}}}

\item{conf_int}{For \code{type == "pred"} the type of confidence intervals; see \code{conf_int} in \code{\link{predict.emfrail}}}

\item{individual}{For \code{type == "pred"} for drawing a curve when the rows of \code{newdata} refer to the same individual; see
\code{individual} in \code{\link{predict.emfrail}}}

\item{...}{Further arguments to be passed to the plot function}
}
\value{
Nothing
}
\description{
Plots for emfrail objects
}
\examples{
mod_rec <- emfrail(Surv(start, stop, status) ~ treatment + number + cluster(id), bladder1,
control = emfrail_control(ca_test = FALSE, lik_ci = FALSE))

# Histogram of the estimated frailties
plot(mod_rec, type = "hist")

# hazard ratio between placebo and pyridoxine
newdata1 <- data.frame(treatment = c("placebo", "pyridoxine"),
                       number = c(1, 3))

plot(mod_rec, type = "hr", newdata = newdata1)

# predicted cumulative hazard for placebo, and number = 1
plot(mod_rec, type = "pred", newdata = newdata1[1,])

# predicted survival for placebo, and number = 1
plot(mod_rec, type = "pred", quantity = "survival", newdata = newdata1[1,])

# predicted survival for an individual that switches from
# placebo to pyridoxine at time = 15
newdata2 <- data.frame(treatment = c("placebo", "pyridoxine"),
                       number = c(1, 3),
                       tstart = c(0, 15),
                       tstop = c(15, Inf))

plot(mod_rec, type = "pred", quantity = "survival", newdata = newdata2, individual = TRUE)
}
\seealso{
\code{\link{predict.emfrail}}, \code{\link{summary.emfrail}}, \code{\link{autoplot.emfrail}}.
}
