% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_curv.R
\name{write.fs.morph.txt}
\alias{write.fs.morph.txt}
\title{Write curv data to file in simple text format}
\usage{
write.fs.morph.txt(filepath, data)
}
\arguments{
\item{filepath}{string. Full path to the output curv file. If it ends with ".gz", the file is written in gzipped format. Note that this is not common, and that other software may not handle this transparently.}

\item{data}{vector of doubles. The brain morphometry data to write, one value per vertex.}
}
\description{
Write vertex-wise brain surface data to a file in a simple text format: one value per line.
}
\seealso{
Other morphometry functions: 
\code{\link{fs.get.morph.file.ext.for.format}()},
\code{\link{fs.get.morph.file.format.from.filename}()},
\code{\link{read.fs.curv}()},
\code{\link{read.fs.mgh}()},
\code{\link{read.fs.morph.gii}()},
\code{\link{read.fs.morph}()},
\code{\link{read.fs.volume}()},
\code{\link{read.fs.weight}()},
\code{\link{write.fs.curv}()},
\code{\link{write.fs.label.gii}()},
\code{\link{write.fs.mgh}()},
\code{\link{write.fs.morph.asc}()},
\code{\link{write.fs.morph.gii}()},
\code{\link{write.fs.morph.ni1}()},
\code{\link{write.fs.morph.ni2}()},
\code{\link{write.fs.morph.smp}()},
\code{\link{write.fs.morph}()},
\code{\link{write.fs.weight.asc}()},
\code{\link{write.fs.weight}()}
}
\concept{morphometry functions}
