% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillovers.R
\name{spilloverDY09}
\alias{spilloverDY09}
\title{Computing spillover from a fevd according to Diebold Yilmaz (2009)}
\usage{
spilloverDY09(est, n.ahead = 100, no.corr, table = F)
}
\arguments{
\item{est}{the estimate of a system, typically VAR estimate in our case}

\item{n.ahead}{how many periods ahead should the FEVD be computed, generally this number
should be high enough so that it won't change with additional period}

\item{no.corr}{boolean parameter whether the off-diagonal in the covariance matrix should be
set to zero}

\item{table}{boolean whether the full spillover table should be returned}
}
\description{
This function is an internal implementation of the spillover.
The spillover is in general defined as the contribution of the other variables
to the fevd of the self variable. This function computes the spillover as the 
contribution of the diagonal elements of the fevd to the total sum of the matrix.
The other functions are just wrappers around this function. In general, other spillovers
could be implemented using this function.
}
\author{
Tomas Krehlik <tomas.krehlik@gmail.com>
}
