% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_theme.R
\name{use_theme}
\alias{use_theme}
\title{Use a CSS theme in Shiny application}
\usage{
use_theme(theme)
}
\arguments{
\item{theme}{Either a path to CSS file (if in \code{www/} folder,
do not include \code{www/} in path), or a theme generated with
\code{\link{create_theme}} and argument \code{output_file = NULL}.}
}
\value{
HTML tags to be included in a UI definition.
}
\description{
Use a CSS theme in Shiny application
}
\examples{
if (interactive()) {
  library(shiny)
  library(fresh)

  ui <- fluidPage(
    use_theme(create_theme(
      theme = "default",
      bs_vars_global(
        body_bg = "#000",
        text_color = "#FFF"
      ),
      bs_vars_wells(
        bg = "#2E2E2E"
      )
    )),
    tags$h1("Inversed color theme"),

    sidebarLayout(
      sidebarPanel(
        "This is the sidebar panel"
      ),
      mainPanel(
        tags$h1("First level title"),
        tags$h2("Second level title"),
        tags$h3("Third level title"),
        tags$h4("Fourth level title"),
        tags$h5("Fifth level title"),
        tags$h6("Sixth level title")
      )
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
