% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_files.R
\name{search_files}
\alias{search_files}
\title{Search Files for a Pattern}
\usage{
search_files(what, verbose = TRUE, ...)
}
\arguments{
\item{what}{A regex pattern for which to search.}

\item{verbose}{Be verbose?}

\item{...}{Arguments passed to \code{\link{list.files}}.}
}
\value{
\link[base:invisible]{Invisibly} a vector of names of files
containing the pattern given by \bold{what}.
}
\description{
This is an approximation of unix find and grep.
}
\examples{
write.csv(mtcars, file.path(tempdir(), "mtcars.csv"))
write.csv(iris, file.path(tempdir(), "iris.csv"))
search_files(what = "Mazda", path = tempdir(), pattern = "^.*\\\\.csv$")
search_files(what = "[Ss]etosa", path = tempdir(), pattern = "^.*\\\\.csv$")
}
