% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmesh.from.annot}
\alias{coloredmesh.from.annot}
\title{Create a coloredmesh from an annotation of an atlas.}
\usage{
coloredmesh.from.annot(
  subjects_dir,
  subject_id,
  atlas,
  hemi,
  surface = "white",
  outline = FALSE
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{atlas}{string or a loaded annotation. If a string, interpreted as the atlas name that should be loaded to get te annotation. E.g., "aparc", "aparc.2009s", or "aparc.DKTatlas". Used to construct the name of the annotation file to be loaded.}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{character string or `fs.surface` instance. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{outline}{logical, whether to draw an outline only instead of filling the regions. Defaults to FALSE. Only makes sense if you did not pass an outline already. The current implementation for outline computation is rather slow, so setting this to TRUE will considerably increase computation time.}
}
\value{
coloredmesh. A named list with entries: "mesh" the \code{\link[rgl]{tmesh3d}} mesh object. "col": the mesh colors. "render", logical, whether to render the mesh. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create a coloredmesh from an annotation of an atlas.
}
\seealso{
Other coloredmesh functions: 
\code{\link{coloredmesh.from.label}()},
\code{\link{coloredmesh.from.mask}()},
\code{\link{coloredmesh.from.morph.native}()},
\code{\link{coloredmesh.from.morph.standard}()},
\code{\link{coloredmesh.from.morphdata}()},
\code{\link{coloredmeshes.from.color}()}
}
\concept{coloredmesh functions}
