% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{vol.mask.from.segmentation}
\alias{vol.mask.from.segmentation}
\title{Extract subset from a volume by value.}
\usage{
vol.mask.from.segmentation(volume, include_values)
}
\arguments{
\item{volume}{numeric 3D array}

\item{include_values}{numerical vector, the intensity values which qualify a voxel to be part of the result (without being set to NA)}
}
\value{
numerical array with same dimensions as the input volume. All values which are not part of `include_values` replaced with `NA`.
}
\description{
Extract subset from a volume by value, set all other voxel values to `NA`. Typically used to extract a brain structure (like corpus callosum) from a volume segmentation (like the `mri/aseg.mgz` file of a subject). You should consider passing the volume and the include values as integers.
}
