% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3objecsdoc.R
\name{tclusteda.object}
\alias{tclusteda.object}
\title{Objects returned by the function \code{\link{tclustfsda}} with the option \code{monitoring=TRUE}}
\value{
The functions \code{print()} and \code{summary()} are used to obtain and print a
 summary of the results. An object of class \code{tclusteda} is a list containing at least the following components:
 \item{call}{the matched call}
 \item{k}{number of groups}
 \item{alpha}{trimming level}
 \item{restrfactor}{restriction factor}
 \item{IDX}{an \code{n-by-length(alpha)} vector containing assignment of each unit to each of the \code{k}
     groups. Cluster names are integer numbers from 1 to k.
     0 indicates trimmed observations. The first column refers to \code{alpha[1]}, the second column
     refers to \code{alpha[2]}, ..., the last column refers to \code{alpha[length(alpha)]}.}
 \item{MU}{a 3 dimensional array of size k-by-p-by-length(alpha) containing the monitoring
     of the centroid for each value of alpha. \code{MU[,,1]}, refers to \code{alpha[1]} ...,
     \code{MU(,,length(alpha)]} refers to \code{alpha[length(alpha)]}.
     The first row in each slice refers to group 1, second row refers to group 2, etc.}
 \item{SIGMA}{ A list of length \code{length(alpha)} containing in element \code{j},
     with \code{j=1, 2, ..., length(alpha)}, the 3D array of size p-by-p-by-k containing
     the \code{k} (constrained) estimated covariance matrices associated with \code{alpha[j]}. }
  \item{Amon}{Amon stands for alpha monitoring. Matrix of size \code{(length(alpha)-1)-by-4} which
     contains for two consecutive values of alpha the monitoring of three quantities
     (change in classification, change in centroid location, change in covariance location).
     \itemize{
     \item 1st col = value of alpha.
     \item 2nd col = ARI index.
     \item 3rd col = squared Euclidean distance between centroids.
     \item 4th col = squared Euclidean distance between covariance matrices.
     }
 }
}
\description{
An object of class \code{\link{tclusteda.object}} holds information about
 the result of a call to \code{\link{tclustfsda}} with the option \code{monitoring=TRUE}.
}
\examples{

 \dontrun{
 data(hbk)
 (out <- tclustfsda(hbk[, 1:3], k=2, monitoring=TRUE))
 class(out)
 summary(out)
 }
}
\keyword{multivariate}
\keyword{robust}
