% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tclustregIC.R
\name{tclustregIC}
\alias{tclustregIC}
\title{Computes \code{tclustreg} for different number of groups \code{k}
 and restriction factors \code{c}.}
\usage{
tclustregIC(
  y,
  x,
  alphaLik,
  alphaX,
  intercept = TRUE,
  plot = FALSE,
  nsamp,
  refsteps = 10,
  reftol = 1e-13,
  equalweights = FALSE,
  wtrim = 0,
  we,
  msg = TRUE,
  RandNumbForNini,
  trace = FALSE,
  ...
)
}
\arguments{
\item{y}{Response variable. A vector with \code{n} elements that
contains the response variable.}

\item{x}{An n x p data matrix (n observations and p variables).
 Rows of x represent observations, and columns represent variables.

 Missing values (NA's) and infinite values (Inf's) are allowed,
 since observations (rows) with missing or infinite values will
 automatically be excluded from the computations.}

\item{alphaLik}{Trimming level, a scalar between 0 and 0.5 or an
integer specifying the number of observations which have to be trimmed.
If \code{alphaLik=0}, there is no trimming.  More in detail, if \code{0 < alphaLik < 1}
clustering is based on \code{h = floor(n * (1 - alphaLik))} observations.
If \code{alphaLik} is an integer greater than 1 clustering is
based on \code{h = n - floor(alphaLik)}. More in detail, likelihood
contributions are sorted and the units associated with the smallest \code{n - h}
contributions are trimmed.}

\item{alphaX}{Second-level trimming or constrained weighted model for \code{x}.}

\item{intercept}{wheather to use constant term (default is \code{intercept=TRUE}}

\item{plot}{If \code{plot=FALSE} (default) or \code{plot=0}  no plot is produced.
If \code{plot=TRUE} a plot with the final allocation is shown (using the spmplot function).
If \code{X} is 2-dimensional, the lines associated to the groups are shown too.}

\item{nsamp}{If a scalar, it contains the number of subsamples which will be extracted.
If \code{nsamp = 0} all subsets will be extracted. Remark - if the number of all possible
subset is greater than 300 the default is to extract all subsets, otherwise just 300.
If \code{nsamp} is a matrix it contains in the rows the indexes of the subsets which
have to be extracted. \code{nsamp} in this case can be conveniently generated by
function \code{subsets()}. \code{nsamp} must have \code{k * p} columns. The first \code{p}
columns are used to estimate the regression coefficient of group 1, ..., the last \code{p}
columns are used to estimate the regression coefficient of group \code{k}.}

\item{refsteps}{Number of refining iterations in each subsample. Default is \code{refsteps=10}.
\code{refsteps = 0} means "raw-subsampling" without iterations.}

\item{reftol}{Tolerance of the refining steps. The default value is 1e-14}

\item{equalweights}{A logical specifying wheather cluster weights in the concentration
 and assignment steps shall be considered. If \code{equalweights=TRUE} we are (ideally)
 assuming equally sized groups, else if \code{equalweights = false} (default) we allow for
 different group weights. Please, check in the given references which functions
are maximized in both cases.}

\item{wtrim}{How to apply the weights on the observations - a flag taking values in c(0, 1, 2, 3, 4).
\itemize{
    \item If \code{wtrim==0} (no weights), the algorithm reduces to the standard \code{tclustreg} algorithm.
    \item If \code{wtrim==1}, trimming is done by weighting the observations using values specified in vector
        \code{we}. In this case, vector \code{we} must be supplied by the user.
    \item If \code{wtrim==2}, trimming is again done by weighting the observations
        using values specified in vector \code{we}. In this case, vector \code{we}
        is computed from the data as a function of the density estimate pdfe.
        Specifically, the weight of each observation is the probability of retaining
        the observation, computed as
        \deqn{pretain_{ig} = 1-pdfe_{ig}/max_{ig}(pdfe_{ig})}
    \item If \code{wtrim==3}, trimming is again done by weighting the observations using
        values specified in vector \code{we}. In this case, each element wei of vector
        \code{we} is a Bernoulli random variable with probability of success
          \eqn{pdfe_{ig}}.
        In the clustering framework this is done under the constraint that no group is empty.
    \item If \code{wtrim==4}, trimming is done with the tandem approach of Cerioli and Perrotta (2014).
}}

\item{we}{Weights. A vector of size n-by-1 containing application-specific weights
Default is a vector of ones.}

\item{msg}{Controls whether to display or not messages on the screen If \code{msg==TRUE} (default)
messages are displayed on the screen. If \code{msg=2}, detailed messages are displayed,
for example the information at iteration level.}

\item{RandNumbForNini}{pre-extracted random numbers to initialize proportions.
Matrix of size k-by-nrow(nsamp) containing the random numbers which
are used to initialize the proportions of the groups. This option is effective only if
\code{nsamp} is a matrix which contains pre-extracted subsamples. The purpose of this
option is to enable the user to replicate the results when the function \code{tclustreg()}
is called using a parfor instruction (as it happens for example in routine IC, where
\code{tclustreg()} is called through a parfor for different values of the restriction factor).
The default is that \code{RandNumbForNini} is empty - then uniform random numbers are used.}

\item{trace}{Whether to print intermediate results. Default is \code{trace=FALSE}.}

\item{...}{potential further arguments passed to lower level functions.}
}
\value{
An S3 object of class \code{\link{tclustreg.object}}
}
\description{
(the last two letters stand for 'Information Criterion') computes
 the values of BIC (MIXMIX), ICL (MIXCLA) or CLA (CLACLA), for different values
 of \code{k} (number of groups) and different values of \code{c}
 (restriction factor for the variances of the residuals), for
 a prespecified level of trimming. In order to minimize randomness, given \code{k},
 the same subsets are used for each value of \code{c}.
}
\references{
Torti F., Perrotta D., Riani, M. and Cerioli A. (2019). Assessing Robust Methodologies for Clustering Linear Regression Data,
     Advances in Data Analysis and Classification, Vol. 13, pp 227-257.
}
\author{
FSDA team, \email{valentin.todorov@chello.at}
}
