% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslhd.R
\name{fslfill}
\alias{fslfill}
\title{Fill image holes}
\usage{
fslfill(file, outfile = NULL, bin = TRUE, retimg = TRUE,
  reorient = FALSE, intern = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{file}{(character) filename of image to be filled}

\item{outfile}{(character) name of resultant filled file}

\item{bin}{(logical) binarize the image before filling}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) pass to \code{\link{system}}}

\item{verbose}{(logical) print out command before running}

\item{...}{additional arguments passed to \code{\link{readnii}}.}
}
\value{
character or logical depending on intern
}
\description{
This function calls \code{fslmaths -fillh} to fill in image holes
and either saves the image or returns an object of class nifti
}
\examples{
if (have.fsl()){
system.time({
dims = c(50, 50, 20)
x = array(rnorm(prod(dims)), dim = dims) 
img = nifti(x, dim= dims, 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
mask = img > .5
eroded = fslerode(mask, kopts = "-kernel boxv 5", retimg=TRUE)
filled = fslfill(eroded, retimg= TRUE)
})
}  
}

