% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DisorderC.R
\name{DisorderC}
\alias{DisorderC}
\title{disorder Content (DisorderC)}
\usage{
DisorderC(dirPath)
}
\arguments{
\item{dirPath}{Path of the directory which contains all output files of VSL2. Each file belongs to a sequence.}
}
\value{
The output is a feature matrix with 2 columns. The number of rows is equal to the number of sequences.
}
\description{
This function extracts ordered and disordered amino acids in protein or peptide sequences. The input to the function is provided by VSL2 software.
Also, the function returns number of order and disorder amino acids in the sequence.
}
\examples{

dir = tempdir()
PredDisdir<-system.file("testForder",package="ftrCOOL")
PredDisdir<-paste0(PredDisdir,"/Disdir/")

mat<-DisorderC(PredDisdir)

}
