% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphabetCheck.R
\name{alphabetCheck}
\alias{alphabetCheck}
\title{AlphabetCheck}
\usage{
alphabetCheck(sequences, alphabet = "aa", label = c())
}
\arguments{
\item{sequences}{is a string vector. Each element is a peptide, protein, DNA, or RNA sequences.}

\item{alphabet}{This parameter shows the alphabet of sequences. If it is set to 'aa', it indicates the
alphabet of amino acids. When it is 'dna', it shows the nucleotide alphabet and in case it equals 'rna', it represents ribonucleotide alphabet.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
'alphabetCheck' returns a list with two elements. The first element is a vector which contains
valid sequences. The second element is a vector which contains the labels of the sequences (if any exists).
}
\description{
This function checks the alphabets in a sequence. If one of the following conditions hold, the sequence will be deleted:
1. A peptide sequence containing non-standard amino acids,
2. A DNA sequence with an alphabet other than A, C, G, or T,
3. An RNA sequence having an alphabet other than A, C, G, or U.
}
\note{
This function receives a sequence vector and the label of sequences (if any).
It deletes sequences (and their labels) containing non-standard alphabets.
}
\examples{

seq<-alphabetCheck(sequences=c("AGDFLIAACNMLKIVYT","ADXVGAJK"),alphabet="aa")

}
