% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{approxNA}
\alias{approxNA}
\title{Approximate missing values for funData objects}
\usage{
approxNA(object)
}
\arguments{
\item{object}{An object of  class \code{funData} with missing values (coded 
by \code{NA}).}
}
\value{
A \code{funData} object where missing values have been imputed.
}
\description{
This function approximates missing values for \code{funData} objects based on
the \link[zoo]{na.approx} interpolation method from the package \pkg{zoo}.
}
\section{Warning}{
 This function requires the package \pkg{zoo} to be 
  installed, otherwise it will throw a warning.
}
\examples{
# Simulate some data
f <- simFunData(N = 10, M = 8, eVal = "linear", eFun = "Poly", argvals = seq(0, 1, 0.01))$simData

# Sparsify, i.e. generate artificial missings in the data
fSparse <- sparsify(f, minObs = 10, maxObs = 50)

# plot
oldpar <- par(no.readonly = TRUE)
par(mfrow = c(1,3))
plot(f, main = "Original Data") 
plot(fSparse, main = "Sparse Data")
plot(approxNA(fSparse), main = "Reconstructed Data")
# faster with plot(fSparse, plotNA = TRUE, main = "Reconstructed Data")

par(oldpar)
}

