% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_fclust.R
\name{ftest_components}
\alias{ftest_components}
\title{Evaluate the weight of each component on functional clustering}
\usage{
ftest_components(fres, opt.nbMax = fres$nbOpt,
                 opt.R2 = FALSE, opt.plot = FALSE)
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained with the whole dataset using the function \code{\link{fclust}}.}

\item{opt.nbMax}{a logical. If \code{opt.plot = TRUE},
at each test, the tree resulting from removing
 each component, assemblage or performance is plotted.}

\item{opt.R2}{a logical. If \code{opt.R2 = TRUE},
the primary tree is validated
and the vectors of coefficient of determination (\code{R^2})
and efficiency (\code{E}) are computed.}

\item{opt.plot}{a logical. If \code{opt.plot = TRUE},
at each test, the tree resulting from removing
each component, assemblage or performance is plotted.}
}
\value{
a list containing a matrix by clustering index.
}
\description{
Evaluate by cross-validation (leave-one-out)
 the effect induced by each component
 on the result of a functional clustering.
}
\details{
a

Each component of the interactive system in consideration
 is successively removed from the dataset,
 the remaining components are functionally clustered,
 then indices of distance between clustering trees
 with and without the component are computed.
 The components can then be hierarchised depending on
 the distance induced by their removing from dataset.
 The used distance criteria are :
  "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
  "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
  "Sokal_Sneath1" and "Sokal_Sneath2" index.
  For more informations, see the notice of R-package \code{clusterCrit}.
  The test is time-consuming.
}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
\keyword{internal}
