% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_fclust.R
\name{ftest_plot_assemblages}
\alias{ftest_plot_assemblages}
\title{Plot the evaluation of weight of each assemblage
  on functional clustering}
\usage{
ftest_plot_assemblages(fres, rtest,
                       main = "Title", opt.crit = "Jaccard", opt.ass = NULL)
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained with the whole dataset using the function \code{\link{fclust}}.}

\item{rtest}{a list of matrices,
each containing the results for a clustering index.
\code{rtest} is an object generated by the function \code{ftest}.}

\item{main}{a string, that is used
as the first, reference part of the title of each graph.}

\item{opt.crit}{a list of strings,
indicating the clustering indices to plot.
The indices can be:
 "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" or "Sokal_Sneath2".
 For more informations, see the notice of R-package \code{clusterCrit}.}

\item{opt.ass}{a list, that can include
\code{opt.ass} = \code{list("all.together", "motifs.together",
"assemblages.together",
"motifs.bymot", "assemblages.bymot", "sorted.leg", "all")}.
This option list manages the plot
of results obtained using the function \code{ftest}
with \code{opt.var = "assemblages"}.
The item order in list is any.

\itemize{
 \item{\code{"all.together", "motifs.together", "assemblages.together"}}
   {  plot \emph{(i)} the general mean index;
   \emph{(ii)} the mean indices for each assembly motif on a same plot;
   and \emph{(iii)} the mean index for each assemblages
   on a same plot,
   when removing one after one each assemblage from the dataset.
   This allows to evaluate the raw robustness of functional clustering
   to perturbation of dataset,
   and the weight of each assemblage on functional clustering.
   }

\item{\code{"motifs.bymot", "assemblages.bymot"}}{  plot
   \emph{(i)} mean assembly motifs,
   assembly motif by assembly motif;
   \emph{(ii)} a graph by removed assemblage,
   assembly motif by assembly motif;
   This allows to evaluate the weight of each assemblage
    on functional clustering.
   }

\item{\code{"sorted.leg"}}{  plot
  the names of assemblages decreasingly sorted
  according to their weight on functional clustering.
  }

\item{\code{"all"}}{  plot all possible graphs.
  This option is equivalent to
  \code{opt.ass} = \code{list("all.together", "motifs.together",
 "assemblages.together",
  "motifs.bymot", "assemblages.bymot", "sorted.leg")}.}
  }}
}
\value{
Nothing. It is a procedure.
}
\description{
Evaluate by cross-validation (leave-one-out)
 the effect induced by leaving out each assemblage
 on the result of a functional clustering.
}
\details{
The trees obtained by leaving out each assemblage
are compared to the reference tree obtained with all assemblages
using different criteria :
"Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" and "Sokal_Sneath2" index.
 For more informations, see the notice of R-package \code{clusterCrit}.
}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
\keyword{internal}
