% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai_multisession.R
\name{mirai_multisession}
\alias{mirai_multisession}
\title{Mirai-based localhost multisession futures}
\usage{
mirai_multisession(
  expr,
  substitute = TRUE,
  envir = parent.frame(),
  ...,
  workers = availableCores()
)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{...}{Additional named elements of the future.}

\item{workers}{The number of parallel processes to use.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.}
}
\value{
An object of class \link{MiraiFuture}.
}
\description{
Mirai-based localhost multisession futures
}
\examples{
plan(mirai_multisession)

# A function that returns a future, note that N uses lexical scoping...
f <- function() future({4 * sum((runif(N) ^ 2 + runif(N) ^ 2) < 1) / N}, seed = TRUE)

# Run a simple sampling approximation of pi in parallel using  M * N points:
N <- 1e6  # samples per worker
M <- 10   # iterations
pi_est <- Reduce(sum, Map(value, replicate(M, f()))) / M
print(pi_est)

plan(sequential)
invisible(mirai::daemons(0)) ## Shut down mirai workers
}
