% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster}
\alias{cluster}
\title{Create a cluster future whose value will be resolved asynchronously in a parallel process}
\usage{
cluster(expr, envir = parent.frame(), substitute = TRUE, lazy = FALSE,
  seed = NULL, globals = TRUE, persistent = FALSE,
  workers = availableWorkers(), user = NULL, revtunnel = TRUE,
  homogeneous = TRUE, gc = FALSE, earlySignal = FALSE, label = NULL,
  ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression} to be evaluated.}

\item{envir}{The \link{environment} from where global
objects should be identified.  Depending on the future
strategy (the \code{evaluator}), it may also be the environment
in which the expression is evaluated.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{lazy}{Specifies whether a future should be resolved
lazily or eagerly (default).}

\item{seed}{(optional) A L'Ecuyer-CMRG RNG seed.}

\item{globals}{(optional) A logical, a character vector,
or a named list for controlling how globals are handled.
For details, see below section.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{workers}{A cluster object created by
\code{\link[parallel]{makeCluster}()}.}

\item{user}{(optional) The user name to be used when communicating
with another host.}

\item{revtunnel}{If TRUE, reverse SSH tunneling is used for the
PSOCK cluster nodes to connect back to the master R process.  This
avoids the hassle of firewalls, port forwarding and having to know
the internal / public IP address of the master R session.}

\item{homogeneous}{If TRUE, all cluster nodes is assumed to use the
same path to \file{Rscript} as the main R session.  If FALSE, the
it is assumed to be on the PATH for each node.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) after the value of the future is collected.}

\item{earlySignal}{Specified whether conditions should be signaled
as soon as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{...}{Additional arguments passed to the "evaluator".}
}
\value{
A \link{ClusterFuture}.
}
\description{
A cluster future is a future that uses cluster evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.
}
\details{
This function will block if all available R cluster nodes are
occupied and will be unblocked as soon as one of the already
running cluster futures is resolved.

The preferred way to create an cluster future is not to call
this function directly, but to register it via
\code{\link{plan}(cluster)} such that it becomes the default
mechanism for all futures.  After this \code{\link{future}()}
and \code{\link{\%<-\%}} will create \emph{cluster futures}.
}
\examples{
\donttest{

## Use cluster futures
cl <- parallel::makeCluster(2L)
plan(cluster, workers = cl)

## A global variable
a <- 0

## Create multicore future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A cluster future is evaluated in a separate process.
## Changing the value of a global variable will not
## affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## CLEANUP
parallel::stopCluster(cl)

}
}
