% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{TWAPLS.w2}
\alias{TWAPLS.w2}
\title{TWA-PLS training function v2}
\usage{
TWAPLS.w2(
  modern_taxa,
  modern_climate,
  nPLS = 5,
  usefx = FALSE,
  fx_method = "bin",
  bin = NA
)
}
\arguments{
\item{modern_taxa}{The modern taxa abundance data, each row represents a
sampling site, each column represents a taxon.}

\item{modern_climate}{The modern climate value at each sampling site.}

\item{nPLS}{The number of components to be extracted.}

\item{usefx}{Boolean flag on whether or not use \code{fx} correction.}

\item{fx_method}{Binned or p-spline smoothed \code{fx} correction: if
\code{usefx = FALSE}, this should be \code{NA}; otherwise,
\code{\link{fx}} function will be used when choosing "bin";
\code{\link{fx_pspline}} function will be used when choosing "pspline".}

\item{bin}{Binwidth to get fx, needed for both binned and p-splined method.
if \code{usefx = FALSE}, this should be \code{NA};}
}
\value{
A list of the training results, which will be used by the predict
function. Each element in the list is described below:
\describe{
\item{\code{fit}}{the fitted values using each number of components.}
\item{\code{x}}{the observed modern climate values.}
\item{\code{taxon_name}}{the name of each taxon.}
\item{\code{optimum}}{the updated taxon optimum}
\item{\code{comp}}{each component extracted (will be used in step 7
regression).}
\item{\code{u}}{taxon optimum for each component (step 2).}
\item{\code{t}}{taxon tolerance for each component (step 2).}
\item{\code{z}}{a parameter used in standardization for each component
(step 5).}
\item{\code{s}}{a parameter used in standardization for each component
(step 5).}
\item{\code{orth}}{a list that stores orthogonalization parameters
(step 4).}
\item{\code{alpha}}{a list that stores regression coefficients (step 7).}
\item{\code{meanx}}{mean value of the observed modern climate values.}
\item{\code{nPLS}}{the total number of components extracted.}
}
}
\description{
TWA-PLS training function, which can perform \code{fx} correction.
\code{1/fx} correction will be applied at step 2 and step 7.
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")

# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Training
fit_t_Tmin2 <- fxTWAPLS::TWAPLS.w2(taxa, modern_pollen$Tmin, nPLS = 5)
fit_tf_Tmin2 <- fxTWAPLS::TWAPLS.w2(
  taxa,
  modern_pollen$Tmin,
  nPLS = 5,
  usefx = TRUE,
  fx_method = "bin",
  bin = 0.02
)
}

}
\seealso{
\code{\link{fx}}, \code{\link{TWAPLS.predict.w}}, and
\code{\link{WAPLS.w}}
}
