/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.CauchyDistribution;

public class CauchyDistributionImpl
extends AbstractContinuousDistribution
implements CauchyDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double median = 0.0;
    private double scale = 1.0;
    private final double solverAbsoluteAccuracy;

    public CauchyDistributionImpl() {
        this(0.0, 1.0);
    }

    public CauchyDistributionImpl(double median, double s) {
        this(median, s, 1.0E-9);
    }

    public CauchyDistributionImpl(double median, double s, double inverseCumAccuracy) {
        this.setMedianInternal(median);
        this.setScaleInternal(s);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    public double cumulativeProbability(double x) {
        return 0.5 + Math.atan((x - this.median) / this.scale) / Math.PI;
    }

    public double getMedian() {
        return this.median;
    }

    public double getScale() {
        return this.scale;
    }

    public double density(double x) {
        double dev = x - this.median;
        return 0.3183098861837907 * (this.scale / (dev * dev + this.scale * this.scale));
    }

    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", p, 0.0, 1.0);
        }
        double ret = p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * Math.tan(Math.PI * (p - 0.5)));
        return ret;
    }

    @Deprecated
    public void setMedian(double median) {
        this.setMedianInternal(median);
    }

    private void setMedianInternal(double newMedian) {
        this.median = newMedian;
    }

    @Deprecated
    public void setScale(double s) {
        this.setScaleInternal(s);
    }

    private void setScaleInternal(double s) {
        if (s <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("scale must be positive ({0})", s);
        }
        this.scale = s;
    }

    protected double getDomainLowerBound(double p) {
        double ret = p < 0.5 ? -1.7976931348623157E308 : this.median;
        return ret;
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.median : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.median - this.scale : (p > 0.5 ? this.median + this.scale : this.median);
        return ret;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

